<?php
/**
* Envato updater
* version 1.0.1
*/

if ( ! function_exists( 'cptch_plugins_loaded_action' ) ) {
	function cptch_plugins_loaded_action() {
		$free = 'captcha-bws/captcha-bws.php';
		$this_plugin = 'captcha-plus/captcha-plus.php';

		if ( ! function_exists( 'deactivate_plugins' ) || ! function_exists( 'is_plugin_active_for_network' ) )
			require_once( ABSPATH . 'wp-admin/includes/plugin.php' );

		if ( function_exists( 'is_multisite' ) && is_multisite() ) {
			if ( ! is_plugin_active_for_network( $this_plugin ) )
				$deactivate_not_for_all_network = true;
		}
		
		if ( isset( $deactivate_not_for_all_network ) && is_plugin_active_for_network( $free ) ) {
			global $wpdb;
			deactivate_plugins( $free );

			$old_blog = $wpdb->blogid;
			/* Get all blog ids */
			$blogids = $wpdb->get_col( "SELECT `blog_id` FROM $wpdb->blogs" );
			foreach ( $blogids as $blog_id ) {
				switch_to_blog( $blog_id );
				activate_plugin( $free );
			}
			switch_to_blog( $old_blog );
		} else {
			deactivate_plugins( $free );
		}
	}
}

if ( ! function_exists( 'cptch_envato_get_plugins' ) ) {
	function cptch_envato_get_plugins( $transient ) {
		global $cptch_plugin_info;

		$wp_plugin_key = 'captcha-plus/captcha-plus.php';
		if ( empty( $cptch_plugin_info ) ) {
			if ( ! function_exists( 'get_plugin_data' ) )
				require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
			$cptch_plugin_info = get_plugin_data( dirname( dirname( __FILE__ ) ) . '/captcha-plus.php' );
		}

		$response = cptch_envato_request( 'https://api.envato.com/v3/market/buyer/list-purchases?filter_by=wordpress-plugins' );

		if ( is_wp_error( $response ) ) {
			echo '<div class="error below-h2"><p>' . $response->get_error_message() . '</p></div>';
			return $transient;
		} elseif ( empty( $response ) || empty( $response['results'] ) ) {
			return $transient;
		}

		/* loop through the marketplace plugins */
		foreach ( $response['results'] as $plugin_element ) {
			$checked_plugin_name = trim( str_replace( 'by BestWebSoft', '', $cptch_plugin_info['Name'] ) );
			$envato_plugin_name  = trim( str_replace( 'by BestWebSoft', '', $plugin_element['item']['wordpress_plugin_metadata']['plugin_name'] ) );

			if ( $checked_plugin_name == $envato_plugin_name && $cptch_plugin_info['AuthorName'] == $plugin_element['item']['wordpress_plugin_metadata']['author'] ) {
				if ( version_compare( $cptch_plugin_info['Version'], $plugin_element['item']['wordpress_plugin_metadata']['version'], '<' ) ) {
					$url = cptch_envato_get_download_url( $plugin_element['item']['id'] );
					if ( ! $url ) {
						echo '<div class="error below-h2"><p>' . esc_html__( 'An unknown Envato API error occurred.', 'captcha-plus' ) . '</p></div>';
					} else {
						$path = explode( '/', $wp_plugin_key );
						$transient->response[ $wp_plugin_key ] = (object) array(
							'package'		=> $url,
							'slug'			=> $path[0],
							'plugin'		=> $wp_plugin_key,
							'new_version'	=> $plugin_element['item']['wordpress_plugin_metadata']['version'],
							'url'			=> $cptch_plugin_info['PluginURI']
						);

						$requires_wp = $tested_wp = null;
						$versions = array();

						/* Set the required and tested WordPress version numbers */
						foreach ( $plugin_element['item']['attributes'] as $value ) {
							if ( 'compatible-software' === $value['name'] ) {
								foreach ( $value['value'] as $version ) {
									$versions[] = str_replace( 'WordPress ', '', trim( $version ) );
								}
								if ( ! empty( $versions ) ) {
									$requires_wp = $versions[ count( $versions ) - 1 ];
									$tested_wp = $versions[0];
								}
								break;
							}
						}

						$envato_transient = array(
							'id' 			=> $plugin_element['item']['id'],
							'name' 			=> ( ! empty( $plugin_element['item']['wordpress_plugin_metadata']['plugin_name'] ) ? $plugin_element['item']['wordpress_plugin_metadata']['plugin_name'] : '' ),
							'author' 		=> ( ! empty( $plugin_element['item']['wordpress_plugin_metadata']['author'] ) ? $plugin_element['item']['wordpress_plugin_metadata']['author'] : '' ),
							'version' 		=> ( ! empty( $plugin_element['item']['wordpress_plugin_metadata']['version'] ) ? $plugin_element['item']['wordpress_plugin_metadata']['version'] : '' ),
							'description' 	=> $plugin_element['item']['wordpress_plugin_metadata']['description'],
							'url' 			=> ( ! empty( $plugin_element['item']['url'] ) ? $plugin_element['item']['url'] : '' ),
							'landscape_url' => ( ! empty( $plugin_element['item']['previews']['landscape_preview']['landscape_url'] ) ? $plugin_element['item']['previews']['landscape_preview']['landscape_url'] : '' ),
							'requires' 		=> $requires_wp,
							'tested' 		=> $tested_wp,
							'number_of_sales' => ( ! empty( $plugin_element['item']['number_of_sales'] ) ? $plugin_element['item']['number_of_sales'] : '' ),
							'updated_at' 	=> ( ! empty( $plugin_element['item']['updated_at'] ) ? $plugin_element['item']['updated_at'] : '' ),
							'rating' 		=> ( ! empty( $plugin_element['item']['rating'] ) ? $plugin_element['item']['rating'] : '' ),
							'rating_count'	=> ( ! empty( $plugin_element['item']['rating_count'] ) ? $plugin_element['item']['rating_count'] : '' ),
							'package'		=> $url
						);

						set_site_transient( 'cptch_envato_plugin', $envato_transient, HOUR_IN_SECONDS );
					}
				}
				break;
			}
		}
		return $transient;
	}
}

/**
* Request for Envato API.
*
* @param  string $url API request URL, including the request method, parameters, file type.
* @return array  The HTTP response.
*/
if ( ! function_exists( 'cptch_envato_request' ) ) {
	function cptch_envato_request( $url ) {
		global $cptch_options, $cptch_plugin_info;

		if ( empty( $cptch_options ) )
			cptch_settings();

		if ( empty( $cptch_options["envato_token"] ) )
			return false;

		$args = array(
			'headers' => array(
				'Authorization' => 'Bearer ' . $cptch_options["envato_token"],
				'User-Agent' => $cptch_plugin_info["Name"] . '/' . $cptch_plugin_info["Version"],
			),
			'timeout' => 20
		);

		$request = wp_safe_remote_request( $url, $args );
		if ( is_wp_error( $request ) )
			return new WP_Error( 'cptch_envato_api_error', $request->get_error_message() );

		$return = json_decode( wp_remote_retrieve_body( $request ), true );
		if ( 200 == wp_remote_retrieve_response_code( $request ) ) {
			if ( null === $return )
				return new WP_Error( 'cptch_envato_api_error', esc_html__( 'An unknown Envato API error occurred.', 'captcha-plus' ) );

			return $return;
		} elseif ( isset( $return['error_description'] ) ) {
			return new WP_Error( 'cptch_envato_api_error', esc_html__( 'Envato API error', 'captcha-plus' ) . ': ' . $return['error_description'], 'captcha-plus' );
		} else {
			return new WP_Error( 'cptch_envato_api_error', esc_html__( 'An unknown Envato API error occurred.', 'captcha-plus' ) );
		}
	}
}

/**
 * Download the item
 *
 * @param  int   $id The item ID.
 * @return bool|array The HTTP response.
 */
if ( ! function_exists( 'cptch_envato_get_download_url' ) ) {
	function cptch_envato_get_download_url( $item_id ) {
		$response = cptch_envato_request( 'https://api.envato.com/v3/market/buyer/download?item_id=' . $item_id . '&shorten_url=true' );

		if ( is_wp_error( $response ) || empty( $response ) || ! empty( $response['error'] ) )
			return false;

		if ( ! empty( $response['wordpress_theme'] ) )
			return $response['wordpress_theme'];

		if ( ! empty( $response['wordpress_plugin'] ) )
			return $response['wordpress_plugin'];

		return false;
	}
}

/**
* Inject API data for premium plugins.
*
* @param bool   $response false
* @param string $action The API action being performed
* @param object $args Plugin arguments
* @return bool|object $response The plugin info or false
*/
if ( ! function_exists( 'cptch_plugins_api' ) ) {
	function cptch_plugins_api( $response, $action, $args ) {
		if ( 'plugin_information' === $action && isset( $args->slug ) && 'captcha-plus' == $args->slug ) {
			$envato_installed = get_site_transient( 'cptch_envato_plugin' );
			if ( $envato_installed ) {
				$response = new stdClass();
				$response->slug = $args->slug;
				$response->plugin = 'captcha-plus/captcha-plus.php';
				$response->plugin_name = $envato_installed['name'];
				$response->name = $envato_installed['name'];
				$response->version = $envato_installed['version'];
				$response->author = $envato_installed['author'];
				$response->homepage = $envato_installed['url'];
				$response->requires = $envato_installed['requires'];
				$response->tested = $envato_installed['tested'];
				$response->downloaded = $envato_installed['number_of_sales'];
				$response->last_updated = $envato_installed['updated_at'];
				$response->sections = array( 'description' => $envato_installed['description'] );
				$response->banners['low'] = $envato_installed['landscape_url'];
				$response->rating = $envato_installed['rating'] / 5 * 100;
				$response->num_ratings = $envato_installed['rating_count'];
				$response->download_link = $envato_installed['package'];
			}
		}

		return $response;
	}
}

if ( ! function_exists( 'cptch_get_additional_forms' ) ) {
	function cptch_get_additional_forms( $additional_forms ) {
		$additional_forms['cf7_contact'] = array( 'name' => 'Contact Form 7' );
		return $additional_forms;
	}
}

if ( ! function_exists( 'cptch_get_additional_forms_slugs' ) ) {
	function cptch_get_additional_forms_slugs( $forms ) {
		$forms[] = 'cf7_contact';
		return $forms;
	}
}

if ( ! function_exists( 'cptch_get_additional_plugins' ) ) {
	function cptch_get_additional_plugins( $additional_plugins ) {
		$additional_plugins['cf7_contact'] = 'contact-form-7/wp-contact-form-7.php';
		return $additional_plugins;
	}
}

if ( ! function_exists( 'cptch_get_additional_plugins_options' ) ) {
	function cptch_get_additional_plugins_options( $args ) {
		$args['cf7_contact'] = array( 'enable'		=> 'cptchpls_cf7' );
		return $args;
	}
}

if ( ! function_exists( 'cptch_get_additional_captcha_form_slugs' ) ) {
	function cptch_get_additional_captcha_form_slugs( $form_slugs ) {
		$form_slugs['contact_form_7'] = 'contact_form_7_captcha_check';
		return $form_slugs;
	}
}
if ( ! function_exists( 'cptch_get_additional_bool_vars' ) ) {
	function cptch_get_additional_bool_vars( $additional_bool_vars ) {
		$additional_bool_vars[] = 'use_limit_attempts_allowlist';
		return $additional_bool_vars;
	}
}

if ( ! function_exists( 'cptch_get_additional_strings_vars' ) ) {
	function cptch_get_additional_strings_vars( $additional_strings_vars ) {
		$additional_strings_vars[] = 'allowlist_message';
		return $additional_strings_vars;
	}
}

if ( ! function_exists( 'cptch_is_compatible_additional_plugins' ) ) {
	function cptch_is_compatible_additional_plugins( $value, $plugin ) {
		if ( 'contact-form-7/wp-contact-form-7.php' == $plugin ) {
			return '3.4';
		}
		return $value;
	}
}

if ( ! function_exists( 'cptch_get_links_of_additional_plugins' ) ) {
	function cptch_get_links_of_additional_plugins( $value, $bws_link, $plugin ) {
		switch ( $plugin ) {
			case 'contact-form-7/wp-contact-form-7.php':
				return 'http://wordpress.org/plugins/contact-form-7';
			default:
				return $value;
		}
	}
}

if ( ! function_exists( 'cptch_cptch_w3tc_notice' ) ) {
	function cptch_cptch_w3tc_notice() {
		/* Notice on the settings page about possible conflict with W3 Total Cache plugin */
		global $cptch_options, $cptch_plugin_info;
		if ( ! is_plugin_active( 'w3-total-cache/w3-total-cache.php' ) ) {
			return;
		}

		if ( empty( $cptch_options ) ) {
			$cptch_options = is_network_admin() ? get_site_option( 'cptch_options' ) : get_option( 'cptch_options' );
		}
		if ( empty( $cptch_options['w3tc_notice'] ) ) {
			return '';
		}
		if( isset( $_GET['cptch_nonce'] ) && wp_verify_nonce( $_GET['cptch_nonce'], 'cptch_clean_w3tc_notice' ) ) {
			unset( $cptch_options['w3tc_notice'] );
			if ( is_network_admin() ) {
				update_site_option( 'cptch_options', $cptch_options );
			} else {
				update_option( 'cptch_options', $cptch_options );
			}
			return '';
		}

		$url = add_query_arg(
			array(
				'cptch_clean_w3tc_notice'	=> '1',
				'cptch_nonce'				=> wp_create_nonce( 'cptch_clean_w3tc_notice' )
			),
			( is_ssl() ? 'https://' : 'http://' ) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']
		);
		$close_link = "<a href=\"{$url}\" class=\"close_icon notice-dismiss\"></a>";
		$settings_link = sprintf(
			'<a href="%1$s">%2$s</a>',
			admin_url( 'admin.php?page=captcha-plus.php#cptch_load_via_ajax' ),
			esc_html__( 'settings page', 'captcha-plus' )
		);
		$message = sprintf(
			esc_html__( 'You\'re using W3 Total Cache plugin. If %1$s doesn\'t work properly, please clear the cache in W3 Total Cache plugin and turn on \'%2$s\' option on the plugin %3$s.', 'captcha-plus' ),
			$cptch_plugin_info['Name'],
			esc_html__( 'Show CAPTCHA after the end of the page loading', 'captcha-plus' ),
			$settings_link
		);
		return
			"<style>
				.cptch_w3tc_notice {
					position: relative;
				}
				.cptch_w3tc_notice a {
					text-decoration: none;
				}
			</style>
			<div class=\"cptch_w3tc_notice error\"><p>{$message}</p>{$close_link}</div>";
	}
}

if ( ! function_exists( 'cptch_get_additional_plugin_name' ) ) {
	function cptch_get_additional_plugin_name( $value, $plugin_slug ) {
		if ( 'cf7_contact' == $plugin_slug ) {
			return 'Contact Form 7';
		}
		return $value;
	}
}

if ( ! function_exists( 'cptch_add_to_cf7' ) ) {
	function cptch_add_to_cf7() {
		global $cptch_options;
		/*
		 * Add the CAPTCHA to the Contact Form 7 plugin form
		 */
		if ( $cptch_options['forms']['cf7_contact']['enable'] ) {
			require_once( dirname( __FILE__ ) . '/captcha_for_cf7.php' );
			/* add shortcode handler */
			wpcf7_add_shortcode_bws_captcha();
			if ( ! cptch_ip_in_allowlist() ) {
				/* validation for captcha */
				add_filter( 'wpcf7_validate_bwscaptcha', 'wpcf7_bws_captcha_validation_filter', 10, 2 );
				/* add messages for Captha errors */
				add_filter( 'wpcf7_messages', 'wpcf7_bwscaptcha_messages' );
				/* add warning message */
				add_action( 'wpcf7_admin_notices', 'wpcf7_bwscaptcha_display_warning_message' );
			}
		}
	}
}

if ( ! function_exists( 'cptch_add_to_tool_panel_cf7' ) ) {
	function cptch_add_to_tool_panel_cf7() {
		global $cptch_options;
		/**
		 * Add BWS CAPTCHA shortcode button in to the tool panel on the Contact Form 7 pages
		 */
		if ( ! isset( $_REQUEST['page'] ) || ! preg_match( '/wpcf7/', $_REQUEST['page'] ) ) {
			return;
		}
		if ( empty( $cptch_options ) ) {
			cptch_settings();
		}
		if ( $cptch_options['forms']['cf7_contact']['enable'] ) {
			require_once( dirname( __FILE__ ) . '/captcha_for_cf7.php' );
			wpcf7_add_tag_generator_bws_captcha();
		}
	}
}

if ( ! function_exists( 'cptch_get_additional_options' ) ) {
	function cptch_get_additional_options( $options, $message ) {
		$options['use_limit_attempts_allowlist'] = array(
			'type'				=> 'radio',
			'title'				=> esc_html__( 'allow list', 'captcha-plus' ),
			'block_description'	=> esc_html__( 'With a allow list you can hide captcha field for your personal and trusted IP addresses.', 'captcha-plus' ),
			'array_options'		=> array(
				'0'	=> array( esc_html__( 'Default', 'captcha-plus' ) . ' <a href="admin.php?page=captcha-allowlist.php" target="_blank">' . esc_html__( 'Manage allow list', 'captcha-plus' ) . '</a>' ),
				'1'	=> array( 'Limit Attempts ' . $message ),
			)
		);
		return $options;
	}
}
if ( ! function_exists( 'cptch_ip_in_allowlist' ) ) {
	function cptch_ip_in_allowlist() {
		return cptch_allowlisted_ip();
	}
}

if ( ! function_exists( 'cptch_is_limit_login_attempts_active' ) ) {
	function cptch_is_limit_login_attempts_active() {
		if ( ! function_exists( 'is_plugin_active' ) ) {
			require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		}
		return
			is_plugin_active( 'limit-login-attempts/limit-login-attempts.php' ) &&
			isset( $_REQUEST['loggedout'] ) &&
			isset( $_REQUEST['cptch_number'] ) &&
			'' == $_REQUEST['cptch_number'];
	}
}

if ( ! function_exists( 'cptch_allowlisted_ip' ) ) {
	function cptch_allowlisted_ip() {
		global $cptch_options, $wpdb;
		$checked = false;
		if ( empty( $cptch_options ) )
			cptch_settings();
		$table = 1 == $cptch_options['use_limit_attempts_allowlist'] ? 'lmtttmpts_allowlist' : 'cptch_allowlist';
		$allowlist_exist = $wpdb->query( "SHOW TABLES LIKE '{$wpdb->prefix}{$table}'" );
		if ( ! empty( $allowlist_exist ) ) {
			$ip = cptch_get_ip();
			if ( ! empty( $ip ) ) {
				$column_exists = $wpdb->query( "SHOW COLUMNS FROM `{$wpdb->prefix}{$table}` LIKE 'ip_from_int'" );
				/* LimitAttempts Free hasn't `ip_from_int`, `ip_to_int` COLUMNS */
				if ( 0 == $column_exists ) {
					$result = $wpdb->get_var( $wpdb->prepare(
						"SELECT `id`
						FROM `{$wpdb->prefix}{$table}`
						WHERE `ip` = %s LIMIT 1;",
						$ip 
					) );
				} else {
					$ip_int = sprintf( '%u', ip2long( $ip ) );
					$result = $wpdb->get_var( $wpdb->prepare(
						"SELECT `id`
						FROM `{$wpdb->prefix}{$table}`
						WHERE ( `ip_from_int` <= %d AND `ip_to_int` >= %d ) OR `ip` LIKE %s LIMIT 1;", 
						$ip_int, $ip_int, $ip
					) );
				}
				$checked = is_null( $result ) || false === $result ? false : true;
			} else {
				$checked = false;
			}
		}
		return $checked;
	}
}

if ( ! function_exists( 'cptch_add_allowlist_page' ) ) {
	function cptch_add_allowlist_page() {
		$allowlist_page = add_submenu_page(
            'captcha-plus.php',
            esc_html__( 'Captcha Plus Allow List', 'captcha-plus' ),
            esc_html__( 'Allow List', 'captcha-plus' ),
            'manage_options',
            'captcha-allowlist.php',
            'cptch_page_router'
        );
        add_action( "load-{$allowlist_page}", 'cptch_add_tabs' );
	}
}

if ( ! function_exists( 'cptch_create_table_allowlist' ) ) {
	function cptch_create_table_allowlist() {
		global $wpdb;

		$sql = "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}cptch_allowlist` (
			`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
			`ip` CHAR(31) NOT NULL,
			`ip_from_int` BIGINT,
			`ip_to_int` BIGINT,
			`add_time` DATETIME,
			PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8;";
		dbDelta( $sql );

		/* remove unnecessary columns from 'allowlist' table */
		$column_exists = $wpdb->query( "SHOW COLUMNS FROM `{$wpdb->prefix}cptch_allowlist` LIKE 'ip_from'" );
		if ( 0 < $column_exists ) {
			$wpdb->query( "ALTER TABLE `{$wpdb->prefix}cptch_allowlist` DROP `ip_from`;" );
		}
		$column_exists = $wpdb->query( "SHOW COLUMNS FROM `{$wpdb->prefix}cptch_allowlist` LIKE 'ip_to'" );
		if ( 0 < $column_exists ) {
			$wpdb->query( "ALTER TABLE `{$wpdb->prefix}cptch_allowlist` DROP `ip_to`;" );
		}
		/* add new columns to 'allowlist' table */
		$column_exists = $wpdb->query( "SHOW COLUMNS FROM `{$wpdb->prefix}cptch_allowlist` LIKE 'add_time'" );
		if ( 0 == $column_exists ) {
			$wpdb->query( "ALTER TABLE `{$wpdb->prefix}cptch_allowlist` ADD `add_time` DATETIME;" );
		}
		/* add unique key */
		if ( 0 == $wpdb->query( "SHOW KEYS FROM `{$wpdb->prefix}cptch_allowlist` WHERE Key_name='ip'" ) ) {
			$wpdb->query( "ALTER TABLE `{$wpdb->prefix}cptch_allowlist` ADD UNIQUE(`ip`);" );
		}
		/* remove not necessary indexes */
		$indexes = $wpdb->get_results( "SHOW INDEX FROM `{$wpdb->prefix}cptch_allowlist` WHERE Key_name Like '%ip_%'" );
		if ( ! empty( $indexes ) ) {
			$query = "ALTER TABLE `{$wpdb->prefix}cptch_allowlist`";
			$drop = array();
			foreach( $indexes as $index )
				$drop[] = " DROP INDEX {$index->Key_name}";
			$query .= implode( ',', $drop );
			$wpdb->query( $query );
		}

		/**
		 * add new columns to the 'cptch_packages' table
		 * @since 4.2.3
		 */
		$column_exists = $wpdb->query( "SHOW COLUMNS FROM `{$wpdb->base_prefix}cptch_packages` LIKE 'settings'" );
		if ( 0 == $column_exists ) {
			$wpdb->query( "ALTER TABLE `{$wpdb->base_prefix}cptch_packages` ADD (`settings` LONGTEXT NOT NULL, `user_settings` LONGTEXT NOT NULL, `add_time` DATETIME NOT NULL );" );
			$wpdb->update(
				"{$wpdb->base_prefix}cptch_packages",
				array( 'add_time' => current_time( 'mysql' ) ),
				array( 'add_time' => '0000-00-00 00:00:00' )
			);
		}
	}
}

if ( ! function_exists( 'cptch_page_allowlist' ) ) {
	function cptch_page_allowlist() {
		if ( 'captcha-allowlist.php' == $_GET['page'] ) {
			require_once( dirname( __FILE__ ) . '/helpers.php' );
			require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
			require_once( dirname( __FILE__ ) . '/class-cptch-allowlist.php' );

			$limit_attempts_info = cptch_get_plugin_status( array( 'limit-attempts/limit-attempts.php', 'limit-attempts-pro/limit-attempts-pro.php' ), get_plugins(), is_network_admin() );
			$page = new Cptch_allowlist( plugin_basename( __FILE__ ), $limit_attempts_info );
			$page->display_content();
		}
	}
}

if ( ! function_exists( 'cptch_allowlist_message' ) ) {
	function cptch_allowlist_message() {
		global $cptch_options;
		return '<label class="cptch_allowlist_message">' . $cptch_options['allowlist_message'] . '</label>';
	}
}

if ( ! function_exists( 'cptch_get_additional_messages' ) ) {
	function cptch_get_additional_messages( $options ) {
		$options['allowlist_message'] = array(
			'title'			=> __( 'Allow Listed IP', 'captcha-plus' ),
			'message'		=> __( 'Your IP address is allow listed.', 'captcha-plus' ),
			'description'	=> __( 'This message will be displayed instead of the captcha field.', 'captcha-plus' )
		);
		return $options;
	}
}

if ( ! function_exists( 'cptch_allowlist_error_message' ) ) {
	function cptch_allowlist_error_message( $results ) {
		if ( $results['errors']->get_error_messages() ) {
			$cptch_error = $results['errors']->get_error_message( 'cptch_error' );
			$lmtttmpts_error = $results['errors']->get_error_message( 'cptch_error_lmttmpts' );
			$error_message = $cptch_error . '<br>' . $lmtttmpts_error;
			$results['errors']->add( 'generic', $error_message );
		}
		return $results;
	}
}

if ( ! function_exists( 'cptch_get_lmtttmpts_error' ) ) {
	function cptch_get_lmtttmpts_error( $value, $la_form_slug ) {
		$value = ( ! has_filter( 'lmtttmpts_check_ip' ) ) ? '' : apply_filters( 'lmtttmpts_wrong_captcha', $la_form_slug, '' );
		$value = $value == $la_form_slug ? '' : $value;		
		return $value;
	}
}

if ( ! function_exists( 'cptch_check_blocked_ip' ) ) {
	function cptch_check_blocked_ip( $allow, $la_form_slug ) {
		/* check for blocked IP in the Limit Attempts plugin lists */
		$errors = apply_filters( 'lmtttmpts_check_ip', true );
		/* if IP is blocked */
		if ( is_wp_error( $errors ) ) {
			$error_codes = $errors->get_error_codes();
			if ( is_array( $error_codes ) && ! empty( $error_codes ) ) {
				$allow = array();
				foreach ( $error_codes as $error_code )
					$allow[] = $errors->get_error_message( $error_code );
				$allow = implode( '<br />', $allow );
			}
		} else {
			do_action( 'lmtttmpts_success_captcha', $la_form_slug, cptch_get_ip() );
		}
		return $allow;
	}
}

/* Add Captcha forms to the Limit Attempts plugin */
if ( ! function_exists( 'cptchpls_add_lmtttmpts_forms' ) ) {
	function cptchpls_add_lmtttmpts_forms( $forms = array() ) {
		if ( ! is_array( $forms ) )
			$forms = array();

		$forms['cptch'] = array(
			'name'		=> 'Captcha Plugin',
			'forms'		=> array(),
		);
		if ( ! function_exists( 'get_plugins' ) ) {
			require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		}
		$captcha_forms = cptch_get_forms();

		foreach ( $captcha_forms as $form_slug => $form_data ) {
			$forms["cptch"]["forms"]["{$form_slug}_captcha_check"] = $form_data;
		}
		return $forms;
	}
}

if ( ! function_exists( 'cptch_get_forms' ) ) {
	function cptch_get_forms() {
		global $cptch_forms;

		$default_forms = array(
			'login_form'				=> array( 'form_name' => esc_html__( 'Login form', 'сaptcha-plus' ) ),
			'registration_form'			=> array( 'form_name' => esc_html__( 'Registration form', 'сaptcha-plus' ) ),
			'reset_password_form'		=> array( 'form_name' => esc_html__( 'Reset password form', 'сaptcha-plus' ) ),
			'comments_form'				=> array( 'form_name' => esc_html__( 'Coments form', 'сaptcha-plus' ) ),
			'contact_form'				=> array( 'form_name' => 'Contact Form' ),
			'booking_form'				=> array( 'form_name' => 'Car Rental V2 Pro' ),
            'contact_form_7'			=> array( 'form_name' => 'Contact Form 7' ),
			'subscriber'				=> array( 'form_name' => 'Subscriber' ),
		);

		$custom_forms = apply_filters( 'cptch_add_custom_form', array() );
		$cptch_forms = array_merge( $default_forms, $custom_forms );

		foreach ( $cptch_forms as $form_slug => $form_data ) {
			$cptch_forms[ $form_slug ]['form_notice'] = cptch_get_form_notice( $form_slug );
		}

		$cptch_forms = apply_filters( 'cptch_forms', $cptch_forms );

		return $cptch_forms;
	}
}

if ( ! function_exists( 'cptch_get_form_notice' ) ) {
	function cptch_get_form_notice( $form_slug = '' ) {
		global $wp_version, $cptch_plugin_info;
		$form_notice = "";
		if ( ! function_exists( 'get_plugins' ) ) {
			require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		}
		$plugins = array(
			'contact_form'			=> array( 'contact-form-plugin/contact_form.php', 'contact-form-pro/contact_form_pro.php' ),
			'booking_form'          => 'bws-car-rental-pro/bws-car-rental-pro.php',
            'subscriber'			=> array( 'subscriber/subscriber.php', 'subscriber-pro/subscriber-pro.php' ),
			'contact_form_7'		=> 'contact-form-7/wp-contact-form-7.php',
			'jetpack_contact_form'	=> 'jetpack/jetpack.php',
			'mailchimp_form'		=>'mailchimp-for-wp/mailchimp-for-wp.php'
		);

		if ( isset( $plugins[ $form_slug ] ) ) {
			$plugin_info = cptch_plugin_status( $plugins[ $form_slug ], get_plugins(), is_network_admin() );

			if ( 'activated' == $plugin_info['status'] ) {
				/* check required conditions */
				if ( 'contact_form_7' == $form_slug ) {
					if ( version_compare( $plugin_info['plugin_info']['Version'], '3.4', '<' ) ) {
						$form_notice = '<a href="' . self_admin_url( 'plugins.php' ) . '">' . sprintf( esc_html__( 'Update %s at least up to %s', 'captcha-plus' ), 'Contact Form 7', 'v3.4' ) . '</a>';
					} elseif (
						defined( 'WPCF7_VERSION' ) &&
						defined( 'WPCF7_REQUIRED_WP_VERSION' ) &&
						version_compare( $wp_version, WPCF7_REQUIRED_WP_VERSION, '<' )
					) {
						$form_notice = sprintf(
							esc_html__( '%1$s %2$s requires WordPress %3$s or higher.', 'captcha-plus' ),
							'Contact Form 7',
							WPCF7_VERSION,
							WPCF7_REQUIRED_WP_VERSION
						);
					}
				}
			} elseif ( 'deactivated' == $plugin_info['status'] ) {
				$form_notice = '<a href="' . self_admin_url( 'plugins.php' ) . '">' . esc_html__( 'Activate', 'captcha-plus' ) . '</a>';
			} elseif ( 'not_installed' == $plugin_info['status'] ) {
				if ( 'contact_form' == $form_slug ) {
					$form_notice = '<a href="https://bestwebsoft.com/products/wordpress/plugins/contact-form/?k=fa26df3911ebcd90c3e85117d6dd0ce0&pn=281&v=' . $cptch_plugin_info["Version"] . '&wp_v=' . $wp_version . '" target="_blank">' . esc_html__( 'Install Now', 'captcha-plus' ) . '</a>';
				} elseif ( 'subscriber' == $form_slug ) {
					$form_notice = '<a href="https://bestwebsoft.com/products/wordpress/plugins/subscriber/?k=c5c7708922e53ab2c3e5c1137d44e3a2&pn=281&v=' . $cptch_plugin_info["Version"] . '&wp_v=' . $wp_version . '" target="_blank">' . esc_html__( 'Install Now', 'captcha-plus' ) . '</a>';
				} else {
					$slug = explode( '/', $plugins[ $form_slug ] );
					$slug = $slug[0];
					$form_notice = sprintf( '<a href="http://wordpress.org/plugins/%s/" target="_blank">%s</a>', $slug, esc_html__( 'Install Now', 'captcha-plus' ) );
				}
			}
		}
		return apply_filters( 'cptch_form_notice', $form_notice, $form_slug );
	}
}

if ( ! function_exists( 'cptch_plugin_status' ) ) {
	function cptch_plugin_status( $plugins, $all_plugins, $is_network ) {
		$result = array(
			'status'		=> '',
			'plugin'		=> '',
			'plugin_info'	=> array(),
		);
		foreach ( (array)$plugins as $plugin ) {
			if ( array_key_exists( $plugin, $all_plugins ) ) {
				if (
					( $is_network && is_plugin_active_for_network( $plugin ) ) ||
					( ! $is_network && is_plugin_active( $plugin ) )
				) {
					$result['status']		= 'activated';
					$result['plugin']		= $plugin;
					$result['plugin_info']	= $all_plugins[ $plugin ];
					break;
				} else {
					$result['status']		= 'deactivated';
					$result['plugin']		= $plugin;
					$result['plugin_info']	= $all_plugins[ $plugin ];
				}

			}
		}
		if ( empty( $result['status'] ) ) {
			$result['status'] = 'not_installed';
		}
		return $result;
	}
}

if ( ! function_exists( 'cptch_get_ip' ) ) {
	function cptch_get_ip() {
		$ip = '';
		if ( isset( $_SERVER ) ) {
			$server_vars = array( 'HTTP_X_REAL_IP', 'HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'REMOTE_ADDR' );
			foreach( $server_vars as $var ) {
				if ( isset( $_SERVER[ $var ] ) && ! empty( $_SERVER[ $var ] ) ) {
					if ( filter_var( $_SERVER[ $var ], FILTER_VALIDATE_IP ) ) {
						$ip = $_SERVER[ $var ];
						break;
					} else { /* if proxy */
						$ip_array = explode( ',', $_SERVER[ $var ] );
						if ( is_array( $ip_array ) && ! empty( $ip_array ) && filter_var( $ip_array[0], FILTER_VALIDATE_IP ) ) {
							$ip = $ip_array[0];
							break;
						}
					}
				}
			}
		}
		return $ip;
	}
}

if ( ! function_exists( 'cptch_notice_cf7' ) ) {
	function cptch_notice_cf7( $options ) {
		/*
		 * Display this notice in order to remind to the user that he need to go on the
		 * Contact Form 7 "edit form" page and insert [BWS_CAPTCHA] shortcode in to the form content
		 */
		if ( ! $options['forms']['cf7_contact']['enable'] && isset( $_REQUEST['cptch']['forms']['cf7_contact']['enable'] ) ) {
			$notices[] = sprintf( esc_html__( "Option for displaying Captcha with Contact Form 7 is enabled. For correct work, please don't forget to add the BWS CAPTCHA block to the necessary form (see %s).", 'captcha-plus' ), '<a href="https://support.bestwebsoft.com/hc/en-us/sections/200538879" target="_blank">FAQ</a>' );
		}
	}
}

if ( ! function_exists( 'cptch_settings_page_misc_action' ) ) {
	function cptch_settings_page_misc_action( $options ) { ?>
		<table class="form-table">
			<tr>
				<th><?php esc_html_e( 'Update the plugin using default WordPress functionality', 'captcha-plus' ); ?></th>
				<td>
					<input type="text" name="cptch_envato_token" class="widefat" value="<?php if ( isset( $options['envato_token'] ) ) echo $options['envato_token']; ?>" autocomplete="off" />
					<p class="description"><a href="https://build.envato.com/create-token/?purchase:download=t&amp;purchase:verify=t&amp;purchase:list=t" target="_blank"><?php esc_html_e( 'Generate your Envato API Personal Token', 'captcha-plus' ); ?></a> (<?php esc_html_e( 'with account used during plugin purchase', 'captcha-plus' ); ?>) <?php esc_html_e( 'and insert it above.', 'captcha-plus' ); ?><br/><?php esc_html_e( "You'll see an update on the Plugins page when new version is available.", 'captcha-plus' ); ?></p>
				</td>
			</tr>
		</table>
		<?php return $options;
	}
}

if ( ! function_exists( 'cptch_before_save_options' ) ) {
	function cptch_before_save_options( $options ) {
		if ( isset( $_POST["cptch_envato_token"] ) )
			$options['envato_token'] = stripslashes( sanitize_text_field( $_POST["cptch_envato_token"] ) );

		return $options;
	}
}

add_action( 'plugins_loaded', 'cptch_plugins_loaded_action' );
/* Inject Envato plugin updates into the response array. */
add_filter( 'pre_set_site_transient_update_plugins', 'cptch_envato_get_plugins' );
add_filter( 'pre_set_transient_update_plugins', 'cptch_envato_get_plugins' );

/* Inject plugin information For Envato */
add_filter( 'plugins_api', 'cptch_plugins_api', 10, 3 );

/* Compatibility with other forms */
add_action( 'cptch_notice_cf7', 'cptch_notice_cf7', 10, 1 );
add_filter( 'cptch_get_additional_forms', 'cptch_get_additional_forms' );
add_filter( 'cptch_get_additional_forms_slugs', 'cptch_get_additional_forms_slugs' );
add_filter( 'cptch_get_additional_plugins', 'cptch_get_additional_plugins' );
add_filter( 'cptch_get_additional_plugins_options', 'cptch_get_additional_plugins_options' );
add_filter( 'cptch_get_additional_captcha_form_slugs', 'cptch_get_additional_captcha_form_slugs' );
add_filter( 'cptch_is_compatible_additional_plugins', 'cptch_is_compatible_additional_plugins', 10, 2 );
add_filter( 'cptch_get_additional_plugin_name', 'cptch_get_additional_plugin_name', 10, 2 );

add_action( 'cptch_add_to_cf7', 'cptch_add_to_cf7' );
add_action( 'cptch_add_to_tool_panel_cf7', 'cptch_add_to_tool_panel_cf7' );

/* Compatibility with limit attempts */
add_filter( 'cptch_get_additional_bool_vars', 'cptch_get_additional_bool_vars' );
add_filter( 'cptch_get_additional_strings_vars', 'cptch_get_additional_strings_vars' );
add_filter( 'cptch_get_additional_options', 'cptch_get_additional_options', 10, 2 );
add_filter( 'cptch_ip_in_allowlist', 'cptch_ip_in_allowlist' );
add_filter( 'cptch_is_limit_login_attempts_active', 'cptch_is_limit_login_attempts_active' );
add_filter( 'cptch_get_lmtttmpts_error', 'cptch_get_lmtttmpts_error', 10, 2 );
add_filter( 'cptch_check_blocked_ip', 'cptch_check_blocked_ip', 10, 2 );
add_filter( 'lmtttmpts_plugin_forms', 'cptchpls_add_lmtttmpts_forms', 10, 1 );
add_filter( 'cptch_allowlist_message', 'cptch_allowlist_message' );
add_filter( 'cptch_get_additional_messages', 'cptch_get_additional_messages' );
add_filter( 'cptch_allowlist_error_message', 'cptch_allowlist_error_message' );

add_action( 'cptch_add_allowlist_page', 'cptch_add_allowlist_page' );
add_action( 'cptch_create_table_allowlist', 'cptch_create_table_allowlist' );
add_action( 'cptch_page_allowlist', 'cptch_page_allowlist' );

add_filter( 'cptch_get_links_of_additional_plugins', 'cptch_get_links_of_additional_plugins', 10, 3 );

add_action( 'cptch_cptch_w3tc_notice', 'cptch_cptch_w3tc_notice' );

/* Add block for plugin settings page */
add_action( 'cptch_settings_page_misc_action', 'cptch_settings_page_misc_action', 10, 1 );
add_filter( 'cptch_before_save_options', 'cptch_before_save_options', 10, 1 );
