<?php

/**
 * Fired during plugin activation
 *
 * @link       http://echopointer.com
 * @since      1.0.0
 *
 * @package    Kas_Dvf
 * @subpackage Kas_Dvf/classes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Kas_Dvf
 * @subpackage Kas_Dvf/classes
 * @author     Syed Muhammad Shafiq <shafiq_shaheen@hotmail.com>
 */
class Kas_Dvf_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
	    
	    // Create post object
	    $kas_results_page = array(
	        'post_title'    => 'Vendor Listing',
	        'post_content'  => '[kas_dokan_vendor_filter]<br>[kas_dokan_vendor_filter_results]',
	        'post_status'   => 'publish',
	        'post_author'   => get_current_user_id(),
	        'post_type'     => 'page',
	    );
	    // Insert the post into the database
	    $page_id = wp_insert_post( $kas_results_page, '' );
	    $result_link = get_permalink($page_id);
	    $g_options = array(
	        'results' => $result_link,
	        'page_id' => $page_id,
	        'show-products' => 0,
	        'distance-type' => 'imperial',
	        'products-perpage' => 10
	    );
	    // add default opitons  
	    update_option('kas-dvf-general', $g_options);
	    
	    Kas_Dvf_Public::generate_location();

	    $f_options = array(
	        'show-country' => 1,
	        'show-state' => 1,
	        'show-city' => 1,
	        'show-store' => 1,
	        'show-zip' => 1,
	        'show-category' => 1
	    );
	    // add form opitons  
	    update_option('kas-dvf-forms', $f_options);
	    
	    $s_options = array(
	        'enable-select2' => 2,
	        'show-mapview' => 2,
	        'map-height' => 400,
	        'map-zoom' => 12,
	        'search-radius' => 100,
	        'get-location' => 1
	    );
	    // add form opitons
	    update_option('kas-dvf-scripts', $s_options);
	    
	}
}