<?php

$menus 			= (array) wp_get_nav_menus();

$menuOptions 	= array(
	'none' 	=> 'Select menu'
);

foreach ($menus as $menuObj ) {
	$menuOptions[ $menuObj->slug ] = $menuObj->name;
}


if( function_exists('xoo_el') ){
	$loginPopupTxt 		= '<a href="'.admin_url( 'admin.php?page=easy-login-woocommerce-settings' ).'" target="_blank">تنظیمات پلاگین</a>';
}
else{
	$loginPopupAction 	= xoo_wsc_admin_settings()->is_plugin_installed('easy-login-woocommerce') ? 'فعالسازی پلاگین' : 'نصب پلاگین'; 
	$loginPopupTxt 		= 'این ویژگی به افزونه بازشوی جداگانه ورود/ثبت ما نیاز دارد.<br>
							<div class="xoo-wsc-el-links">
								<a target="nolink" class="xoo-wsc-el-install">'.$loginPopupAction.'</a>
								<a href="https://wordpress.org/plugins/easy-login-woocommerce/" target="_blank">لینک پلاگین</a>
							</div>
							';
}



$settings = array(

	/***** Shortcode ****/

	array(
		'callback' 		=> 'select',
		'title' 		=> 'افزودن به منو',
		'id' 			=> 'shbk-menu',
		'section_id' 	=> 'sh_bk',
		'args' 			=> array(
			'options' 	=> $menuOptions
		),
		'default' 	=> 'none',
	),

	array(
		'callback' 		=> 'checkbox_list',
		'title' 		=> 'نمایش',
		'id' 			=> 'shbk-show',
		'section_id' 	=> 'sh_bk',
		'args' 			=> array(
			'options' 	=> array(
				'icon' 			=> 'آیکن',
				'subtotal' 		=> 'جمع فرعی',
				'count' 		=> 'شمارش',
			)
		),
		'default' 	=> array(
			'icon', 'subtotal', 'count',
		),
	),


	/** SIDE CART HEADER **/

	array(
		'callback' 		=> 'checkbox_list',
		'title' 		=> 'نمایش',
		'id' 			=> 'sch-show',
		'section_id' 	=> 'sc_head',
		'args' 			=> array(
			'options' 	=> array(
				'notifications' => 'اعلان ها',
				'basket' 		=> 'آیکن سبد',
				'close' 		=> 'آیکن بستن'
			),
		),
		'default' 	=> array(
			'notifications', 'basket', 'close'
		)
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'نمایش اعلان برای چند ثانیه',
		'id' 			=> 'sch-notify-time',
		'section_id' 	=> 'sc_head',
		'default' 		=> '5000',
		'desc' 			=> '( 1 second = 1000 )'
	),


	/** SIDE CART BODY **/

	array(
		'callback' 		=> 'checkbox_list',
		'title' 		=> 'نمایش',
		'id' 			=> 'scb-show',
		'section_id' 	=> 'sc_body',
		'args' 			=> array(
			'options' 	=> array(
				'total_sales' 	=> 'تعداد فروش محصول',
				'product_image' => 'تصویر محصول',
				'product_name' 	=> 'نام محصول',
				'product_price' => 'قیمت محصول',
				'product_total' => 'جمع کل محصولات',
				'product_qty' 	=> 'تعداد محصول',
				'product_meta' 	=> 'متغیرهای محصول',
				'product_link' 	=> 'لینک به صفحه محصول',
				'product_del'	=> 'حذف محصول',
			),
		),
		'default' 	=> array(
			'total_sales', 'product_price', 'product_qty', 'product_total', 'product_name', 'product_link', 'product_del', 'product_image', 'product_meta', 'product_qty'
		)
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'نمایش تعداد و قیمت',
		'id' 			=> 'scbp-qpdisplay',
		'section_id' 	=> 'sc_body',
		'args' 			=> array(
			'options' 	=> array(
				'one_liner' => 'نمایش در یک ردیف',
				'separate' 	=> 'نمایش بصورت جداگانه',
			),
		),
		'default' 		=> 'one_liner',
		'desc' 			=> 'زمانی که به روز رسانی مقدار مجاز نیست'
	),



	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'اجازه به روز رسانی کمیت',
		'id' 			=> 'scb-update-qty',
		'section_id' 	=> 'sc_body',
		'default' 		=> 'yes',
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'تاخیر به روز رسانی کمیت',
		'id' 			=> 'scb-update-delay',
		'section_id' 	=> 'sc_body',
		'default' 		=> '500',
		'desc' 			=> 'منتظر بمانید تا درخواست بروزرسانی مقدار به سرور ارسال شود (1 ثانیه = 1000)'
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'قیمت محصول',
		'id' 			=> 'scb-prod-price',
		'section_id' 	=> 'sc_body',
		'args' 			=> array(
			'options' 	=> array(
				'actual' 	=> 'فقط قیمت واقعی را نشان دهید',
				'sale'		=> 'نمایش قیمت معمولی و فروش',
			),
		),
		'default' 	=> 'actual',
	),

	array(
		'callback' 		=> 'select',
		'title' 		=> 'نمایش متغیر در عنوان محصول',
		'id' 			=> 'scb-pname-var',
		'section_id' 	=> 'sc_body',
		'args' 			=> array(
			'options' 	=> array(
				'no' 	=> 'نه، بصورت جداگانه نمایش بده',
				'yes'	=> 'بله',
			),
		),
		'default' 	=> 'no',
		'desc' 		=> 'اگر نه انتخاب شده است، مطمئن شوید که «متا محصول» در بالا علامت زده شده است تا داده‌های تغییرات به طور جداگانه نمایش داده شود.'
	),



	/** SIDE CART FOOTER **/

	array(
		'callback' 		=> 'checkbox_list',
		'title' 		=> 'نمایش',
		'id' 			=> 'scf-show',
		'section_id' 	=> 'sc_footer',
		'args' 			=> array(
			'options' 	=> array(
				'subtotal' 		=> 'جمع فرعی',
				'discount' 		=> 'تخفیف',
				'tax' 			=> 'مالیات',
				'shipping' 		=> 'مبلغ حمل و نقل',
				'shipping_calc' => 'محاسبه گر حمل و نقل',
				'fee' 			=> 'سایر هزینه ها',
				'total' 		=> 'جمع کل',
				'coupon' 		=> 'تغییر فهرست کوپن',
				'empty_cart' 	=> 'لینک خالی کردن سبد خرید'
			),
		),
		'default' 	=> array(
			'subtotal', 'discount', 'tax', 'shipping', 'shipping_calc', 'fee', 'total', 'coupon', 'order_notes', 'empty_cart'
		)
	),


	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'نمایش کل در دکمه پرداخت',
		'id' 			=> 'scf-chkbtntotal-en',
		'section_id' 	=> 'sc_footer',
		'default' 		=> 'yes',
	),

	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'اسلایدر/پاپ آپ ورود را هنگام پرداخت باز کنید',
		'id' 			=> 'scf-chklogin-en',
		'section_id' 	=> 'sc_footer',
		'default' 		=> 'no',
		'desc' 			=> 'از کاربران بخواهید قبل از پرداخت وارد شوند/ثبت نام کنند. با جمع آوری داده ها می توانید روند پرداخت را هموارتر کنید.<br>'.$loginPopupTxt
	),


	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'وقتی سبد خرید خالی است، متن پاورقی را مخفی کنید',
		'id' 			=> 'scf-ftext-hide',
		'section_id' 	=> 'sc_footer',
		'default' 		=> 'yes',
		'desc' 			=> 'متن پاورقی را در زیر «بخش متن‌ها» تنظیم کنید '
	),


	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'پی پال',
		'id' 			=> 'scf-pec-enable',
		'section_id' 	=> 'sc_footer',
		'default' 		=> 'no',
		'desc' 			=> '<a href="https://wordpress.org/plugins/woocommerce-paypal-payments/" target="_blank">دانلود افزونه</a><br>تنظیمات پی پال: اضافه کردن سبد خرید در زیر | مکان های دکمه هوشمند| '
	),


	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'پرداخت آمازون',
		'id' 			=> 'scf-amaz-enable',
		'section_id' 	=> 'sc_footer',
		'default' 		=> 'no',
		'desc' 			=> '<a href="https://wordpress.org/plugins/woocommerce-gateway-amazon-payments-advanced/" target="_blank">دانلود افزونه</a><br>تنظیمات Amazon Pay: Amazon Pay را در سبد خرید کوچک بررسی کنید '
	),


	/*** PROGRESS BAR ***/

	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'فعالسازی',
		'id' 			=> 'scbar-en',
		'section_id' 	=> 'sc_bar',
		'default' 		=> 'yes',
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'مقدار نوار پیشرفت به عنوان',
		'id' 			=> 'scbar-total',
		'section_id' 	=> 'sc_bar',
		'args' 			=> array(
			'options' 	=> array(
				'total'			=> 'جمع کل سبد خرید',
				'subtotal' 		=> 'جمع فرعی سبد خرید',
				'subtotal_tax' 	=> 'جمع سبد خرید شامل مالیات'
			),
		),
		'default' 	=> 'subtotal_tax',
		'desc' 		=> 'مقداری که برای پر کردن نوار پیشرفت استفاده می شود'
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'موقعیت نوار',
		'id' 			=> 'scbar-pos',
		'section_id' 	=> 'sc_bar',
		'args' 			=> array(
			'options' 	=> array(
				'xoo_wsc_header_end'  	=> 'سربرگ',
				'xoo_wsc_body_start' 	=> 'قبل از محصولات',
				'xoo_wsc_body_end' 		=> 'بعد از محصولات',
				'xoo_wsc_footer_start' 	=> 'شروع پاورقی',
				'xoo_wsc_footer_end' 	=> 'پایان پاورقی',
			),
		),
		'default' 	=> 'xoo_wsc_body_start',
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'نوار تقسیم',
		'id' 			=> 'scbar-divide',
		'section_id' 	=> 'sc_bar',
		'args' 			=> array(
			'options' 	=> array(
				'equal'	=> 'برابر',
				'prop' 	=> 'به تناسب',
			),
		),
		'default' 	=> 'equal',
	),


	array(
		'callback' 		=> 'checkbox_list',
		'title' 		=> 'نمایش',
		'id' 			=> 'scbar-show',
		'section_id' 	=> 'sc_bar',
		'args' 			=> array(
			'options' 	=> array(
				'remaining' 	=> 'متن باقیمانده',
				'title' 		=> 'عنوان',
				'amount' 		=> 'مقدار'
			),
		),
		'default' 	=> array(
			'remaining', 'title', 'amount'
		)
	),


	array(
		'callback' 		=> 'custombardata',
		'title' 		=> 'نقاط بررسی',
		'id' 			=> 'scbar-data',
		'section_id' 	=> 'sc_bar',
		'default' 		=> '',
	),

	array(
		'callback' 		=> 'text',
		'title' 		=> 'متن کامل',
		'id' 			=> 'scbar-comptext',
		'section_id' 	=> 'sc_bar',
		'default' 		=> 'تبریک میگم شما تمام دستاوردها را باز کرده اید.',
	),


	/*** SUGGESTED PRODUCTS ***/

	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'فعالسازی',
		'id' 			=> 'scsp-enable',
		'section_id' 	=> 'suggested_products',
		'default' 		=> 'yes',
	),


	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'نمایش در دستگاه های موبایل',
		'id' 			=> 'scsp-mob-enable',
		'section_id' 	=> 'suggested_products',
		'default' 		=> 'yes',
	),



	array(
		'callback' 		=> 'checkbox_list',
		'title' 		=> 'نمایش',
		'id' 			=> 'scsp-show',
		'section_id' 	=> 'suggested_products',
		'args' 			=> array(
			'options' 	=> array(
				'image' 	=> 'تصویر محصول',
				'title' 	=> 'عنوان محصول',
				'price' 	=> 'قیمت محصول',
				'addtocart' => 'دکمه افزودن به سبد خرید',
			),
		),
		'default' 	=> array(
			'image', 'price', 'addtocart', 'title'
		)
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'نوع محصولات',
		'id' 			=> 'scsp-type',
		'section_id' 	=> 'suggested_products',
		'args' 			=> array(
			'options' 	=> array(
				'cross_sells'	=> 'محبوب',
				'related' 		=> 'مرتبط',
				'up_sells'		=> 'پر فروش'
			),
		),
		'default' 	=> 'related'
	),


	array(
		'callback' 		=> 'textarea',
		'title' 		=> 'شناسه سفارشی محصولات',
		'id' 			=> 'scsp-ids',
		'section_id' 	=> 'suggested_products',
		'default' 		=> '',
		'desc' 			=> 'شناسه محصول با کاما جدا شده است.',
		'args' 			=> array(
			'rows' => 2
		)
	),



	array(
		'callback' 		=> 'number',
		'title' 		=> 'حداکثر تعداد محصولات',
		'id' 			=> 'scsp-count',
		'section_id' 	=> 'suggested_products',
		'default' 		=> 5,
	),


	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'محصولات تصادفی',
		'id' 			=> 'scsp-random',
		'section_id' 	=> 'suggested_products',
		'default' 		=> 'yes',
		'desc' 			=> 'اگر فروش متقابل/پر فروش ذکر شده در بالا در دسترس نیست، سایر محصولات تصادفی را نشان دهید'
	),



	/** MAIN **/

	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'باز کردن خودکار سبد خرید',
		'id' 			=> 'm-auto-open',
		'section_id' 	=> 'main',
		'default' 		=> 'yes',
		'desc' 			=> 'هنگامی که محصول به سبد خرید اضافه می شود'
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'افزودن به سبد خرید ایجکس',
		'id' 			=> 'm-ajax-atc',
		'section_id' 	=> 'main',
		'args' 			=> array(
			'options' 	=> array(
				'yes' 		=> 'بله',
				'cat_no' 	=> 'بله، به جز دسته بندی محصولات',
				'cat_yes' 	=> 'بله، فقط برای دسته بندی محصولات',
				'no'		=> 'خیر',
			),
		),
		'default' 		=> 'yes',
		'desc' 			=> 'بدون تازه کردن صفحه به سبد خرید اضافه کنید'
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'شناسه های دسته (افزودن ایجکس به سبد خرید)',
		'id' 			=> 'm-ajax-atc-catid',
		'section_id' 	=> 'main',
		'desc' 			=> 'شناسه دسته خود را اینجا اضافه کنید. (با کاما از هم جدا می شوند). <br> <a href="https://woocommerce.com/document/find-product-category-ids/" target="_blank">یافتن شناسه دسته بندی</a>'
	),


	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'انیمیشن افزودن به سبد خرید',
		'id' 			=> 'm-flycart',
		'section_id' 	=> 'main',
		'default' 		=> 'yes',
		'desc' 			=> 'با حالت ایجکس افزودن به سبد خرید کار می کند'
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'ترتیب سبد خرید',
		'id' 			=> 'm-cart-order',
		'section_id' 	=> 'main',
		'args' 			=> array(
			'options' 	=> array(
				'asc' 	=> 'کالایی که اخیراً در انتهای سبد اضافه شده است.',
				'desc'	=> 'موردی که اخیراً در بالا اضافه شده است',
			),
		),
		'default' 	=> 'asc',
		'desc' 		=> 'اگر محصولات باندل/کامپوزیت دارید، گزینه پایانی را انتخاب کنید'
	),

	array(
		'callback' 		=> 'select',
		'title' 		=> 'تعداد سبد',
		'id' 			=> 'm-bk-count',
		'section_id' 	=> 'main',
		'args' 			=> array(
			'options' 	=> array(
				'quantity'	=> 'مجموع تعداد تمام محصولات',
				'items' 	=> 'تعداد محصولات',
			),
		),
		'default' 	=> 'items'
	),



	array(
		'callback' 		=> 'select',
		'title' 		=> 'لیست کوپن ها',
		'id' 			=> 'm-cp-list',
		'section_id' 	=> 'main',
		'args' 			=> array(
			'options' 	=> array(
				'all'		=> 'نمایش همه',
				'available' => 'فقط نمایش موارد قابل دسترسی',
				'hide' 		=> 'نمایش نده'
			),
		),
		'default' 	=> 'all'
	),

	array(
		'callback' 		=> 'number',
		'title' 		=> 'حداکثر تعداد کوپن ها',
		'id' 			=> 'm-cp-count',
		'section_id' 	=> 'main',
		'default' 		=> 20,
	),

	array(
		'callback' 		=> 'textarea',
		'title' 		=> 'شناسه پست کوپن های سفارشی',
		'id' 			=> 'm-cp-custom',
		'section_id' 	=> 'main',
		'default' 		=> '',
		'desc' 			=> 'فقط این کوپن ها را نمایش دهید. شناسه پست کوپن را با کاما جدا کنید. برای فهرست کردن همه، خالی بگذارید'
	),

	array(
		'callback' 		=> 'textarea',
		'title' 		=> 'سبد خرید در صفحات نمایش داده نشود',
		'id' 			=> 'm-hide-cart',
		'section_id' 	=> 'main',
		'default' 		=> '',
		'desc' 			=> 'از نوع پست / شناسه صفحه / اسلاگ که با کاما جدا شده اند استفاده کنید. به عنوان مثال: پست، تماس با ما، درباره ما. برای همه صفحات غیر ووکامرس، از no-woocommerce استفاده کنید'
	),

	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'پیوند مشاهده سبد خرید WC را حذف کنید',
		'id' 			=> 'm-viewcart-del',
		'section_id' 	=> 'main',
		'default' 		=> 'no',
		'desc' 			=> 'حذف دکمه مشاهده سبد خرید/لینک اضافه شده توسط ووکامرس در ایجکسی افزودن به سبد خرید',
	),



	/***** TEXTS *****/
	array(
		'callback' 		=> 'text',
		'title' 		=> 'تیتر سبد خرید',
		'id' 			=> 'sct-cart-heading',
		'section_id' 	=> 'texts',
		'default' 		=> 'سبد خرید شما',
	),

	array(
		'callback' 		=> 'text',
		'title' 		=> 'دکمه ادامه',
		'id' 			=> 'sct-ft-contbtn',
		'section_id' 	=> 'texts',
		'default' 		=> 'ادامه خرید',
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'دکمه سبد خرید',
		'id' 			=> 'sct-ft-cartbtn',
		'section_id' 	=> 'texts',
		'default' 		=> 'مشاهده سبد خرید',
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'دکمه تسویه حساب',
		'id' 			=> 'sct-ft-chkbtn',
		'section_id' 	=> 'texts',
		'default' 		=> 'تسویه حساب',
	),

	array(
		'callback' 		=> 'text',
		'title' 		=> 'سبد خرید خالی',
		'id' 			=> 'sct-empty',
		'section_id' 	=> 'texts',
		'default' 		=> 'سبد خرید شما خالی است',
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'دکمه فروشگاه',
		'id' 			=> 'sct-shop-btn',
		'section_id' 	=> 'texts',
		'default' 		=> 'بازگشت به فروشگاه',
		'desc' 			=> 'زمانی که سبد خالی است نمایش داده می شود'
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'جمع فرعی',
		'id' 			=> 'sct-subtotal',
		'section_id' 	=> 'texts',
		'default' 		=> 'جمع فرعی',
	),

	array(
		'callback' 		=> 'text',
		'title' 		=> 'متن پاورقی',
		'id' 			=> 'sct-footer',
		'section_id' 	=> 'texts',
		'default' 		=> 'برای اطلاع از هزینه حمل و نقل، لطفاً جهت تسویه حساب اقدام کنید.',
	),

	array(
		'callback' 		=> 'text',
		'title' 		=> 'متن دکمه حذف',
		'id' 			=> 'sct-delete',
		'section_id' 	=> 'texts',
		'default' 		=> 'حذف',
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'تیتر محصولات پیشنهادی',
		'id' 			=> 'sct-sp-txt',
		'section_id' 	=> 'texts',
		'default' 		=> "محصولاتی که ممکن است بپسندید",
	),



	array(
		'callback' 		=> 'text',
		'title' 		=> 'ادامه خرید',
		'id' 			=> 'scu-continue',
		'section_id' 	=> 'urls',
		'default' 		=> '#',
		'desc' 			=> 'از # برای بستن سبد خرید استفاده کنید و در همان صفحه بمانید'
	),

	array(
		'callback' 		=> 'text',
		'title' 		=> 'سبد خرید',
		'id' 			=> 'scu-cart',
		'section_id' 	=> 'urls',
		'default' 		=> wc_get_cart_url(),
	),

	array(
		'callback' 		=> 'text',
		'title' 		=> 'تسویه حساب',
		'id' 			=> 'scu-checkout',
		'section_id' 	=> 'urls',
		'default' 		=> wc_get_checkout_url(),
	),

	array(
		'callback' 		=> 'text',
		'title' 		=> 'بازگشت به فروشگاه',
		'id' 			=> 'm-shop-url',
		'section_id' 	=> 'urls',
		'default' 		=> get_permalink( wc_get_page_id( 'shop' ) ),
		'desc' 			=> 'زمانی که سبد خرید خالی است نمایش بده'
	),


);

return apply_filters( 'xoo_wsc_admin_settings', $settings, 'general' );

?>
