<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://designingmedia.com/
 * @since      1.0.0
 *
 * @package    Wp_Whmcs_Sync
 * @subpackage Wp_Whmcs_Sync/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Wp_Whmcs_Sync
 * @subpackage Wp_Whmcs_Sync/admin
 * @author     Designingmedia <http://designingmedia.com/>
 */
class Wp_Whmcs_Sync_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	private $meta_data;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;
        
        //all whmcs sync settings
		$meta_options = get_option( 'wp-whmcs-sync-admin-page', true );
		if(is_array($meta_options)) {
			$this->meta_data = $meta_options;
		}

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Wp_Whmcs_Sync_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wp_Whmcs_Sync_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/wp-whmcs-sync-admin.css', array(), $this->version, 'all' );
        wp_enqueue_style( 'sweetalert-style', 'https://cdn.jsdelivr.net/npm/sweetalert2@11.10.0/dist/sweetalert2.min.css', array(), $this->version, 'all' );


	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Wp_Whmcs_Sync_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wp_Whmcs_Sync_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/wp-whmcs-sync-admin.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( 'sweeetalert', 'https://cdn.jsdelivr.net/npm/sweetalert2@11.10.0/dist/sweetalert2.all.min.js', array( 'jquery' ), $this->version, false );

		// Get the page by slug
		$whmcs_page = get_post(get_option( '_whmcs_sync_page_id' ));
		$logs = '';
		$debug_logs = get_option( 'whmcs_sync_logger_entries', true );
		if($this->meta_data['whmcs-debug'] == true){
			if(!empty($debug_logs)){
				$logs = $debug_logs;
			}
		}

		// Localize the script with new data
		$translation_array = [
			'support_team_debug' => __('Empower our support team to assist you effectively...', 'wp-whmcs-sync'),
			'whmcs_sync_page'    => __('Explore the Sync Page for streamlined operations.', 'wp-whmcs-sync'),
			'installation_check' => __('Verify my installation configuration.', 'wp-whmcs-sync'),
			'installation_btn'   => __('Diagnose Potential Setup Problems', 'wp-whmcs-sync'),
			'help_desc_before_a' => __('Navigate to the dedicated WHMCS page on your WordPress website', 'wp-whmcs-sync'),
			'help_desc_after_a'  => __('Customize the page link by editing the page and adjusting the permalink. <strong>Important:</strong> Please refrain from deleting this page!', 'wp-whmcs-sync'),
			'whmcs_success'		 => __('WHMCS-Sync is working!', 'wp-whmcs-sync'),
			'whmcs_error'		 => __('WHMCS-Sync not configured!', 'wp-whmcs-sync'),
			'copy_shortcode'	 => __('Shortcode has been copied.', 'wp-whmcs-sync'),
		];

		$whmcs_page_guid = '';
		if(get_post(get_option( '_whmcs_sync_page_id' ))){
			$whmcs_page_guid = get_option( '_whmcs_sync_page_id' ) ? get_post(get_option( '_whmcs_sync_page_id' ))->guid : '';
		} else {
			update_option('_whmcs_sync_page_id', '');
		}
		// Localize the script with URLs
		$urls = [
			'siteUrl' => home_url(),  // Consider using home_url() instead of site_url() based on your requirements.
			'ajaxUrl' => admin_url('admin-ajax.php'),
			'whmcsSync' => $whmcs_page_guid,
			'whmcsSlug' => get_option( '_whmcs_sync_page_id' ) ? get_post_field('post_name', get_option( '_whmcs_sync_page_id' )) : ''
		];

		// Combine localization data into a single array
		$localization_data = [
			'js_string_localize' => $translation_array,
			'urls_to_frontend'  => $urls,
			'debug_logs' => $logs,
			'whmcs_page' => $whmcs_page ? 'true' : 'false',
			'whmcs_options' => $this->meta_data
		];

		// Localize the script with combined data
		wp_localize_script($this->plugin_name, 'localization_data', $localization_data);

	}
    
	/**
	 * Method to add custom CSS for whmcs-user
	 */
    public function whmcs_enqueue_custom_admin_css(){
		if(wp_get_current_user()->roles[0] === 'whmcs-usr'){
			wp_enqueue_style( 'custom-admin-styles', plugin_dir_url( __FILE__ ) . 'css/custom-admin-styles.css', array(), $this->version, 'all' );
			wp_localize_script($this->plugin_name, 'whmcsUsr', ['true']);
		} else {
			wp_localize_script($this->plugin_name, 'whmcsUsr', ['false']);
		}
		
	}

	// public function pre($data){
	// 	echo '<pre>'; print_r($data);
	// }
	
	/**
	 * Method to add rewrite rules for the friendly url support
	 */
	public function custom_whmcs_rewrite_rules() {
		$page_slug = get_option( '_whmcs_sync_page_id' ) ? get_post_field('post_name', get_option( '_whmcs_sync_page_id' )) : '';
		if(!empty($page_slug)){
			// add_rewrite_rule('^devbunch-whmcs/([^/]*)/([^/]*)/?','index.php?page_id=2517&ccce=$matches[1]','top');
			add_rewrite_rule('^'.$page_slug.'/index/?','index.php?page_id='.get_option( '_whmcs_sync_page_id' ).'&ccce=index','top');
			add_rewrite_rule('^'.$page_slug.'/([^/]*)/?([^/]*)?','index.php?page_id='.get_option( '_whmcs_sync_page_id' ).'&ccce=$matches[1]&other_param=$matches[2]','top');
		}
	}

	/**
	 * Callback method to manage things before saving CSF
	 */
	public function whmcs_csf_before_save_callback($options) {
		// update_option( 'whmcs_sync_validate', true );
		if(is_array($options)){
			$this->whmcs_validate_envato_purchase_code($options);
		}
		//apply validation, check if url found then create WHMCS-sync page
		$this->whmcs_validation_check_before_save($options);

		//clear logs if user uncheck the debug
		// $this->whmcs_clear_logs($options);
	}

	/**
	 * Method to validate envato purchase code through AJAX
	 */
	public function whmcs_envato_validation_handler(){
		if(isset($_POST['action']) && $_POST['action'] === 'whmcs_envato_validation' && isset($_POST['pruchaseCode'])){
			if(!empty($_POST['pruchaseCode'])){
				$envato_validation = get_option( 'whmcs_sync_validate' );
				if($envato_validation != true){
					$personal_token = '0iz45dNaCFAPlOGzjsXqXk3qQ6wq6DR0';
					$url = "https://api.envato.com/v3/market/author/sale?code=" . $_POST['pruchaseCode'];
					$request_headers = array();
					$request_headers[] = 'Authorization: Bearer ' . $personal_token;
					$request_headers[] = 'Accept: application/json';
					//$post_field_string = http_build_query($info, '', '&');
					//$post_field_string = $url;
					$curl = curl_init($url);
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
					curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
					//curl_setopt($curl, CURLOPT_POSTFIELDS, $post_field_string);
					curl_setopt($curl, CURLOPT_HTTPHEADER, $request_headers);
					curl_setopt($curl, CURLOPT_POST, 0);
					//curl_setopt($curl, CURLOPT_HEADER,1);
					$exec = json_decode(curl_exec($curl), true);
					if (isset($exec["error"])) {
						wp_send_json_error( 'wrongCode' );
					} else {
						if(is_array($exec['item'])){
							// if($exec['item']['id'] == '20786821'){
							if($exec['item']['id'] == '49599276'){
								update_option( 'whmcs_sync_validate', true );
								wp_send_json_success( 'validated' );
							} else {
								update_option( 'whmcs_sync_validate', false );
								wp_send_json_error( 'wrongCode' );
							}
						}
					}
				} else if($envato_validation == true){
					wp_send_json_success( 'validated' );
				}
			} else {
				wp_send_json_error( 'emptyCode' );
			}
		}
	}

	/**
	 * Method to validate envato purchase code
	 */
	private function whmcs_validate_envato_purchase_code($options){
		update_option( 'whmcs_sync_validate', true );
		// delete_option( 'whmcs_sync_validate' );
		if(!empty($options['whmcs-envato-license'])){
			$envato_validation = get_option( 'whmcs_sync_validate' );
			if($envato_validation != true){
				$personal_token = '0iz45dNaCFAPlOGzjsXqXk3qQ6wq6DR0';
				$url = "https://api.envato.com/v3/market/author/sale?code=" . $options['whmcs-envato-license'];
				$request_headers = array();
				$request_headers[] = 'Authorization: Bearer ' . $personal_token;
				$request_headers[] = 'Accept: application/json';
				//$post_field_string = http_build_query($info, '', '&');
				//$post_field_string = $url;
				$curl = curl_init($url);
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
				curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
				//curl_setopt($curl, CURLOPT_POSTFIELDS, $post_field_string);
				curl_setopt($curl, CURLOPT_HTTPHEADER, $request_headers);
				curl_setopt($curl, CURLOPT_POST, 0);
				//curl_setopt($curl, CURLOPT_HEADER,1);
				$exec = json_decode(curl_exec($curl), true);			
				if (isset($exec["error"])) {
					?>
						<div class="notice notice-error whmcs-notices whmcs-error is-dismissible">
							<p> <?php _e('Something Went Wrong! Your Envato purchase code is invalid.', 'wp-whmcs-sync') ?> </p>
						</div>
					<?php
					// echo '<script>alert(JSON.stringify({"result": "access_denied", "reason": "wrong_p_code"}));</script>';
					// $options['whmcs-envato-license'] = '';
					// update_option( 'wp-whmcs-sync-admin-page', $options );
					// wp_redirect( admin_url('admin.php?page=wp-whmcs-sync#tab=envato-license-verification') );
					// die();

				} else {
					if(is_array($exec['item'])){
						// if($exec['item']['id'] == '20786821'){
						if($exec['item']['id'] == '49599276'){
							update_option( 'whmcs_sync_validate', true );
						} else {
							?>
								<div class="notice notice-error whmcs-notices whmcs-error is-dismissible">
									<p> <?php _e('Something Went Wrong! Your Envato purchase code is invalid.', 'wp-whmcs-sync') ?> </p>
								</div>
							<?php
							update_option( 'whmcs_sync_validate', false );
						}
					}
				}
			}
		}
		return $options;
	}

	/**
	 * Method to show custom notices
	 */
	private function whmcs_validation_check_before_save($options){
		$envato_validation = get_option( 'whmcs_sync_validate' );
		//if url found empty show notice
		if (empty($options['whmcs-url']) || $envato_validation != true) {
			?>
				<div class="notice notice-error whmcs-notices whmcs-error is-dismissible">
					<p> <?php _e('Something Went Wrong! Check your envato purchase code or update your WHMCS connection settings in the plugin control panel for WHMCS Sync.', 'wp-whmcs-sync') ?> </p>
				</div>
			<?php
			// $options['whmcs-url'] = '';
        } else {
			?>
				<div class="notice notice-success whmcs-notices whmcs-success is-dismissible">
					<p> <?php _e('WP WHMCS Sync successfully installed.', 'wp-whmcs-sync') ?> </p>
				</div>
			<?php

			// Create WHMCS-sync page if not found
			if(empty(get_option( '_whmcs_sync_page_id' ))){
				$query_args = array(
					'post_type'   => 'page',
					'post_status' => 'publish',
					'name'        => 'WHMCS-Sync',
					'posts_per_page' => 1,
				);

				$query = new WP_Query($query_args);

				if (!$query->have_posts()) {
					// If page not found, create a new one
					$this->whmcs_create_page($options);
				} 
				else {
					if(is_array($query->posts)){
						$page = get_post($query->posts[0]->ID);
						update_option( '_whmcs_sync_page_id', $query->posts[0]->ID );
					}
				}
				// Restore the global $post variable after the query
				wp_reset_postdata();
			}
		}

        return $options;
	}

	/**
	 * Method to create WHMCS page if not created on inputing WHMCS url
	 */
	private function whmcs_create_page($options){
		$page = array(
			'post_title'    => __('WHMCS-Sync', 'wp-whmcs-sync'),
			'post_content'  => '',
			'post_status'   => 'publish',
			'post_type'     => 'page',
		);

		$page_id = wp_insert_post($page);
		update_option( '_whmcs_sync_page_id', $page_id );
	}

	/**
	 * Method to clear WHMCS logs
	 */
	private function whmcs_clear_logs($options){
		if($options['whmcs-debug'] == false){
			$debug_logs = get_option( 'whmcs_sync_logger_entries', true );
			if(!empty($debug_logs)){
				delete_option( 'whmcs_sync_logger_entries' );
			}
		}
	}

	/**
	 * Method to trigger get-in-touch form submission
	 */
	public function get_in_touch_handler(){
		if(isset($_POST['action']) && $_POST['action'] === 'get_in_touch'){
			if(!empty($_POST['name']) && !empty($_POST['email']) && !empty($_POST['subject']) && !empty($_POST['comment'])){
				if (filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
					// Set email parameters
					$email = sanitize_email($_POST['email']);
					$headers = 'From: '.$_POST['name'].' <'.$email.'>';

					$email = wp_mail('support@designingmedia.com', $_POST['subject'], $_POST['comment'], $headers);
					if($email == true){
						wp_send_json_success( 'true' );
					}
				} else {
					wp_send_json_error( 'invalid email' );
				}
			}
		}
	}

	/**
	 * Method to trigger service reminders
	 */
	public function whmcs_sync_service_reminders(){
		if(isset($_SESSION['whmcs_client_id']) && isset($_SESSION['whmcs_client_email'])){
			$body = [
				'action'       => 'GetClientsAddons',
				'username'     => $this->meta_data['whmcs-api-identifier'],
				'password'     => $this->meta_data['whmcs-api-secret'],
				'clientid'     => $_SESSION['whmcs_client_id'],
				'stats'        => true,
				'responsetype' => 'json',
			];

			$client_addons = $this->whmcs_api_calling($body);
			if($client_addons && $client_addons['result'] === 'success'){
				foreach ($client_addons['addons']['addon'] as $key => $addon) {
					if($addon === 'Active'){
						// Get the next due date
						$next_due_date = strtotime($addon['nextduedate']);

						// Calculate the difference in seconds between the current date and the next due date
						$time_diff = $next_due_date - time();

						// Calculate the difference in days
						$days_diff = floor($time_diff / (60 * 60 * 24));

						// Check if there are 1 or 2 days left until the next due date
						if ($days_diff == 1 || $days_diff == 2) {
							// Send email to the user
							$to = $_SESSION['whmcs_client_email'];
							$subject = 'Reminder: Next Due Date Approaching';
							$message = 'Your next due date is approaching. Please make sure to make the payment on time for the order id: '.$addon['orderid'].'.';
							$headers = 'From: Your Website <noreply@example.com>';

							wp_mail($to, $subject, $message, $headers);
						}
					}
				}
			}
		}
	}

	/**
	 * Methd to clear cache files
	 */
	public function clear_cache_handler(){
		if(isset($_POST['action']) && $_POST['action'] === 'clear_cache' && isset($_POST['cache'])){
			if(!empty($_POST['cache']) && $_POST['cache'] === 'clear'){
				$cached_files_path = ABSPATH . 'wp-content/plugins/' . $this->plugin_name . '/public/cache';

				// Get list of files in the directory
				$files = glob($cached_files_path . '/*');

				// Loop through each file and delete it
				foreach ($files as $file) {
					if (is_file($file)) {
						unlink($file);
					}
				}
				
				wp_send_json_success( 'cache_cleared' );
			}
		}
	}
}