<?php

/**
 * Fired during plugin deactivation
 *
 * @link       http://designingmedia.com
 * @since      1.0.0
 *
 * @package    Wp_Whmcs_Sync
 * @subpackage Wp_Whmcs_Sync/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Wp_Whmcs_Sync
 * @subpackage Wp_Whmcs_Sync/includes
 * @author     Designingmedia <http://designingmedia.com>
 */
class Wp_Whmcs_Sync_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		$timestamp = wp_next_scheduled( 'whmcs_sync_service_reminders' );
		wp_unschedule_event( $timestamp, 'whmcs_sync_service_reminders' );
	}

}
