<?php

/**
 * Abstract Class for creating meta boxes using CodeStart Framework
 *
 * @since      0.9.0
 * @package    Wp_Whmcs_Sync
 * @subpackage Wp_Whmcs_Sync/includes
 * @author     
 */
abstract class Wp_Whmcs_Sync_Meta {
	private $prefix;
	protected $post_type;
	private $mem_prefix;

	public function __construct( $plugin_name ) {
		$this->prefix = $plugin_name;

		$this->init_meta();
		$this->introduce_tabs();
		$this->admin_init();

	}

	/**
	 * Method to create admin options
	 *
	 * @return void
	 */
	private function admin_init(  ){
		
		// Path to the JSON file
		$font_file_path = plugin_dir_path(__FILE__) . 'wp-whmcs-sync-google-font-list.json';
		// Read the JSON file content
		$json_content = file_get_contents($font_file_path);
		// Decode the JSON string into a PHP array
		$fonts_array = json_decode($json_content, true);
		
		// Create options
		CSF::createOptions(
			'wp-whmcs-sync-admin-page',
			array(
				'menu_title'         => __( 'WHMCS-Sync Settings', 'wp-whmcs-sync' ),
				'menu_slug'          => 'wp-whmcs-sync',
				'framework_title'    => __( 'WHMCS-Sync Options', 'wp-whmcs-sync' ),
				'menu_position'      => 15,
				'show_search'        => false,
				'show_reset_all'     => false,
				'show_reset_section' => false,
				'ajax_save'          => false,
				// 'menu_icon'          => 'https://ps.w.org/dummy-images/assets/icon-256x256.png?rev=2024916',
			)
		);

		//integration settings
		CSF::createSection(
			'wp-whmcs-sync-admin-page',
			array(
				'title'  => __( 'Integration Options', 'wp-whmcs-sync' ),
				'icon'   => 'fa fa-plug',
				'fields' => array(

					array(
						'id'    => 'whmcs-url',
						'type'  => 'text',
						'title' => __('WHMCS URL', 'wp-whmcs-sync'),
						'desc'  => __('Please enter your WHMCS URL and simply click the "Validate" button to ensure it&rsquo;s the correct URL. Afterward, just click "Save" to save your settings. If you&rsquo;d like to preview the final integrated page, click on the "View Page" button.', 'wp-whmcs-sync'),
						'class' => 'whmcs-url-field',
					),

					array(
						'id'      => 'whmcs-load-whmcs-invoice-style',
						'type'    => 'switcher',
						'title'   => __('Load WHMCS invoice style', 'wp-whmcs-sync'),
						'desc'    => __('This feature will apply a Style to your invoices if you&rsquo;ve already placed a Style.css file in the WHMCS URL/Template/CSS/invoice.css directory. If you don&rsquo;t have a Style.css file for your invoices, please reach out to our support team, and we&rsquo;ll provide you with a standard CSS file.', 'wp-whmcs-sync'),
						'default' => true,
					),

					array(
						'id'        => 'whmcs-jquery-library',
						'type'      => 'select',
						'title'     => __('jQuery library', 'wp-whmcs-sync'),
						'options'   => array(
							'whmcs' => 'WHMCS',
							'wp'    => 'WordPress',
							'none'  => 'None',
						),
						'default'   => 'whmcs',
					),

					array(
						'id'             => 'whmcs-template',
						'type'           => 'select',
						'title'          => __('Template', 'wp-whmcs-sync'),
						'options'        => array(
							'twenty-one' 		 => 'twenty-one',
							'six'    	 		 => 'six',
							'five'   	 		 => 'five',
							'portal' 	 		 => 'portal',
							'hostiko'	 		 => 'hostiko',
							'hostiko-material'	 => 'hostiko-material',
							'resellpress'        => 'resellpress',
						),
						'default'        => 'six',
						'desc'           => __('Select your preferred WHMCS Template, or if you are a user of the Hostiko/Resellpress WordPress Theme, choose Hostiko/Resellpress for more options.', 'wp-whmcs-sync')
					),

					array(
						'id'      => 'whmcs-disable-theme-header-footer',
						'type'    => 'switcher',
						'title'   => __('Disable Theme header/footer for WHMCS-Sync page', 'wp-whmcs-sync'),
						'desc'    => __('Activate this option to disable the Header/Footer of WordPress for the Sync Page.', 'wp-whmcs-sync'),
						'class'   => 'whmcs-disable-theme-header-footer',
						'default' => false
					),

					array(
						'id'    => 'whmcs-custom-layout',
						'type'  => 'number',
						'title' => __('Please add custom layout number', 'wp-whmcs-sync'),
						'desc'	=> __('Please enter the Hostiko/Resellpress Layout version you want to integrate, such as &rsquo;85&rsquo; this feature only works with the latest version of Hostiko/Resellpress Template.', 'wp-whmcs-sync'),
						'class' => 'whmcs-hostiko-layout',
					),

					array(
						'id'      => 'whmcs-disable-hostiko-header-footer',
						'type'    => 'switcher',
						'title'   => __('Enable Hostiko header/footer for WHMCS-Sync page', 'wp-whmcs-sync'),
						'desc'    => __('Activate this option to enable the Header/Footer of WordPress for the Sync Page.', 'wp-whmcs-sync'),
						'class'   => 'whmcs-disable-hostiko-header-footer',
						'default' => false
					),
				)
			),
		);

		//whmcs api
		CSF::createSection(
			'wp-whmcs-sync-admin-page',
			array(
				'title'  => __( 'API Configuration', 'wp-whmcs-sync' ),
				'icon'   => 'fa fa-code',
				'fields' => array(

					array(
						'id'      => 'whmcs-sync-sso',
						'type'    => 'switcher',
						'title'   => __('Enable WHMCS-Sync SSO', 'wp-whmcs-sync'),
						'desc'    => __('Experience seamless user access with our integrated WHMCS-Sync Single Sign-On (SSO) feature.', 'wp-whmcs-sync'),
						'default' => false
					),

					array(
						'id'      => 'whmcs-api',
						'type'    => 'text',
						'title'   => __('Please enter your WHMCS API URL', 'wp-whmcs-sync'),
						'desc'	  => __('Please enter the complete URL of your WHMCS API; it should look like this: "https://www.yourdomain.com/path/to/whmcs/includes/api.php".', 'wp-whmcs-sync')
					),

					array(
						'id'      => 'whmcs-api-identifier',
						'type'    => 'text',
						'title'   => __('Please enter your API Identifier', 'wp-whmcs-sync'),
						'desc'	  => __('The identifier code appears as "D4j1dKYE3g40VROOPCGyJ9zRwP0ADJIv".', 'wp-whmcs-sync')
					),

					array(
						'id'      => 'whmcs-api-secret',
						'type'    => 'text',
						'title'   => __('Please enter your API Secret', 'wp-whmcs-sync'),
						'desc'	  => __('The Secret code appears as "F1CKGXRIpylMfsrig3mwwdSdYUdLiFlo".', 'wp-whmcs-sync')
					),
				)
			),
		);

		//other settings
		CSF::createSection(
			'wp-whmcs-sync-admin-page',
			array(
				'title'   => __( 'Advanced Settings', 'wp-whmcs-sync' ),
				'icon'    => 'fa fa-tools',
				'fields'  => array(

					array(
						'id'      => 'whmcs-friendly-url-support',
						'type'    => 'switcher',
						'title'   => __('Enable WHMCS Friendly URL support', 'wp-whmcs-sync'),
						'default' => false,
					),

					array(
						'id'      => 'whmcs-sync-cache',
						'type'    => 'switcher',
						'title'   => __('Enable WHMCS-Sync cache', 'wp-whmcs-sync'),
						'default' => false,
					),

					array(
						'id'    => 'whmcs-custom-css',
						'type'  => 'textarea',
						'title' => __('Custom CSS', 'wp-whmcs-sync'),
						'class' => 'whmcs-custom-css',
					),

					array(
						'id'      => 'whmcs-load-whmcs-style',
						'type'    => 'switcher',
						'title'   => __('Integrate WHMCS Design', 'wp-whmcs-sync'),
						'desc'    => __('If you have your own custom styles for your WHMCS template, you can upload them to the {your_whmcs_path/templates/your_selected_template/css/} with name style.css. This will automatically include your style.css in the header of your WHMCS sync template.', 'wp-whmcs-sync'),
						'default' => true,
					),

					array(
						'id'    => 'whmcs-sync-style',
						'type'  => 'switcher',
						'title' => __('Customize WHMCS-Sync Appearance', 'wp-whmcs-sync'),
						'desc'	=> __('Tailor the appearance of your integrated WHMCS seamlessly with your WordPress site. Activate this option to load your own custom styles, ensuring a cohesive and branded look across your entire online presence.', 'wp-whmcs-sync'),
					),

					array(
						'id'        		  => 'whmcs-color-group',
						'type'      		  => 'color_group',
						'title'     		  => __('Color Group', 'wp-whmcs-sync'),
						'options'   		  => array(
							'primary-color'   => __('Primary Color', 'wp-whmcs-sync'),
							'secondary-color' => __('Secondary Color', 'wp-whmcs-sync'),
							'anchor-color'    => __('Anchor Background Color', 'wp-whmcs-sync'),
							'bg-color'        => __('Background Color', 'wp-whmcs-sync'),
							'bg-color-2'      => __('Background Color 2', 'wp-whmcs-sync'),
							'bg-color-3'      => __('Background Color 3', 'wp-whmcs-sync'),
							'color-2'         => __('Color 2', 'wp-whmcs-sync'),
							'color-3' 		  => __('Color 3', 'wp-whmcs-sync'),
							'color-4' 		  => __('Color 4', 'wp-whmcs-sync'),
						)
					),

					// array(
					// 	'id'      => 'opt-palette-1',
					// 	'type'    => 'palette',
					// 	'title'   => 'Palette',
					// 	'options' => array(
					// 	  'set1'  => array( '#f04e36', '#f36e27', '#f3d430', '#ed1683' ),
					// 	  'set2'  => array( '#f9ca06', '#b5b546', '#2f4d48', '#212b2f' ),
					// 	  'set3'  => array( '#4153ab', '#6e86c7', '#211f27', '#d69762' ),
					// 	  'set4'  => array( '#162526', '#508486', '#C8C6CE', '#B45F1A' ),
					// 	  'set5'  => array( '#bbd5ff', '#ccab5e', '#fff55f', '#197c5d' ),
					// 	),
					// 	'default' => 'set3',
					// ),

					array(
						'id'    => 'whmcs-enable-loader-css',
						'type'  => 'switcher',
						'title' => __('Enable loader css', 'wp-whmcs-sync'),
						'desc'  => __('', 'wp-whmcs-sync'),
					),

					array(
						'id'    => 'whmcs-loader-css',
						'type'  => 'textarea',
						'title' => __('Loader CSS', 'wp-whmcs-sync'),
						'desc'	=> __('Visit <a target="_blank" href="https://cssloaders.github.io/">https://cssloaders.github.io/</a> click on loader you want to add in your page, copy and paste the CSS here.', 'wp-whmcs-sync'),
						'class' => 'whmcs-loader-css',
					),

					array(
						'id'          => 'whmcs-sync-font-family',
						'type'        => 'select',
						'title'       => __('Change font family', 'wp-whmcs-sync'),
						'chosen'      => true,
						'ajax'        => true,
						'placeholder' => __('Select an option', 'wp-whmcs-sync'),
						'options' 	  => $fonts_array
					),

					array(
						'id'       => 'whmcs-footer',
						'type'     => 'select',
						'title'    => __(' Footer', 'wp-whmcs-sync'),
						'options'  => array(
							'page' => 'Page',
							'site' => 'Site',
							'none' => 'None',
						),
						'default'  => 'site',
						'desc'     => __('Demonstrate your support for WP WHMCS Sync by proudly showcasing the Designingmedia footer on your website. By displaying the Designingmedia footer, you contribute to the growth and development of this plugin.', 'wp-whmcs-sync')
					),

				)
			),
		);

		//debug log entries
		CSF::createSection(
			'wp-whmcs-sync-admin-page',
			array(
				'title'     => __( 'Debug Log Entries', 'wp-whmcs-sync' ),
				'icon'      => 'fa fa-copy',
				'fields'    => array(
					array(
						'id'    => 'whmcs-debug',
						'type'  => 'switcher',
						'title' => __('Debug', 'wp-whmcs-sync'),
						'desc'  => __('Encountering issues with the WP WHMCS Sync plugin? Activate the debug mode to generate a comprehensive debug log, providing valuable insights for our support team. This log is instrumental in diagnosing and resolving any challenges you may be facing.', 'wp-whmcs-sync'),
					),
				)
			),
		);

		//help section
		CSF::createSection(
			'wp-whmcs-sync-admin-page',
			array(
				'title'     => __( 'Help', 'wp-whmcs-sync' ),
				'icon'      => 'fas fa-bars',
				'fields'    => array(
					array(
						'id'    => 'opt-color-1',
						'type'  => 'color',
						'title' => 'Color',
					),
				)
			),
		);

		//envato pruchase section
		CSF::createSection(
			'wp-whmcs-sync-admin-page',
			array(
				'title'  => __( 'Envato License Verification', 'wp-whmcs-sync' ),
				'icon'   => 'fa fa-check',
				'fields' => array(
					array(
						'id'    => 'whmcs-envato-license',
						'type'  => 'text',
						'title' => __('Enter Envato License', 'wp-whmcs-sync'),
					),
				)
			),
		);

		//whmcs shortcode tab
		CSF::createSection(
			'wp-whmcs-sync-admin-page',
			array(
				'title'  => __( 'WHMCS Shortcode', 'wp-whmcs-sync' ),
				'icon'   => 'fa fa-info-circle',
				'fields' => array(
					array(
						'id'    => 'whmcs-info',
						'type'  => 'text',
						'title' => __('Enter Envato License', 'wp-whmcs-sync'),
					),
				)
			),
		);
	}


	/**
	 * Method to create metabox
	 *
	 * @return void
	 */
	private function init_meta() {
		CSF::createMetabox(
			$this->prefix,
			array(
				'title'     => __( $this->meta_title, 'wp-whmcs-sync' ),
				'post_type' => $this->post_type,
			)
		);
	}

	/**
	 * Method to populate the metabox
	 *
	 * @return void
	 */
	private function introduce_tabs() {
		$tabs = $this->get_fields();
		foreach ( $tabs as $tab ) {
			CSF::createSection( $this->prefix, $tab );
		}
	}
}
