<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://designingmedia.com
 * @since             1.0
 * @package           Wp_Whmcs_Sync
 *
 * @wordpress-plugin
 * Plugin Name:       ادغام وردپرس با WHMCS
 * Plugin URI:        https://wpnovin.com
 * Description:       ادغام وردپرس با WHMCS یک افزونه قدرتمند و همه کاره وردپرس است که برای یکپارچه سازی یکپارچه مدیریت مشتری و سیستم صورتحساب WHMCS (راه حل کامل مدیریت میزبان وب) با وب سایت وردپرس شما طراحی شده است. این افزونه با ارائه یک رابط یکپارچه برای مشتریان شما، تجربه کاربری را ساده می کند و به آنها امکان دسترسی، مدیریت و خرید بسته های هاست، دامنه ها و سایر خدمات را مستقیماً از سایت وردپرس شما می دهد.
 * Version:           2.2.1
 * Author:            نوین وردپرس
 * Author URI:        https://wpnovin.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wp-whmcs-sync
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 0.1 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'WP_WHMCS_SYNC_VERSION', '1.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wp-whmcs-sync-activator.php
 */
function activate_wp_whmcs_sync() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wp-whmcs-sync-activator.php';
	Wp_Whmcs_Sync_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wp-whmcs-sync-deactivator.php
 */
function deactivate_wp_whmcs_sync() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wp-whmcs-sync-deactivator.php';
	Wp_Whmcs_Sync_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_wp_whmcs_sync' );
register_deactivation_hook( __FILE__, 'deactivate_wp_whmcs_sync' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-wp-whmcs-sync.php';

/**
 * Codestar Framework include
 */
require_once plugin_dir_path( __FILE__ ) . 'includes/codestar-framework/classes/setup.class.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    0.1
 */
function run_wp_whmcs_sync() {

	$plugin = new Wp_Whmcs_Sync();
	$plugin->run();

}
run_wp_whmcs_sync();
