/*global welaunch_change, wp, welaunch */

/**
 * Media Uploader
 * Dependencies        : jquery, wp media uploader
 * Feature added by    : Smartik - http://smartik.ws/
 * Date                  : 05.28.2013
 */

( function( $ ) {
	'use strict';

	var isFiltered;

	welaunch.field_objects       = welaunch.field_objects || {};
	welaunch.field_objects.media = welaunch.field_objects.media || {};

	welaunch.field_objects.media.init = function( selector ) {
		if ( ! selector ) {
			selector = $( document ).find( '.welaunch-group-tab:visible' ).find( '.welaunch-container-media:visible' );
		}

		$( selector ).each(
			function() {
				var el     = $( this );
				var parent = el;

				if ( ! el.hasClass( 'welaunch-field-container' ) ) {
					parent = el.parents( '.welaunch-field-container:first' );
				}

				if ( parent.is( ':hidden' ) ) {
					return;
				}

				if ( parent.hasClass( 'welaunch-field-init' ) ) {
					parent.removeClass( 'welaunch-field-init' );
				} else {
					return;
				}

				isFiltered = false;

				// Remove the image button.
				el.find( '.remove-image, .remove-file' ).unbind( 'click' ).on(
					'click',
					function() {
						welaunch.field_objects.media.removeFile( $( this ).parents( 'fieldset.welaunch-field:first' ) );
					}
				);

				// Upload media button.
				el.find( '.media_upload_button' ).unbind().on(
					'click',
					function( event ) {
						welaunch.field_objects.media.addFile( event, $( this ).parents( 'fieldset.welaunch-field:first' ) );
					}
				);
			}
		);
	};

	// Add a file via the wp.media function.
	welaunch.field_objects.media.addFile = function( event, selector ) {
		var frame;
		var libFilter;
		var filter;
		var data;
		var thumbSrc;
		var height;
		var key;
		var object;

		var jQueryel = $( this );

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( frame ) {
			frame.open();
			return;
		}

		// Get library filter data.
		filter = $( selector ).find( '.library-filter' ).data( 'lib-filter' );

		// Must exist to do decoding.
		if ( undefined !== filter ) {
			if ( '' !== filter ) {
				libFilter  = [];
				isFiltered = true;
				filter     = decodeURIComponent( filter );
				filter     = JSON.parse( filter );

				$.each(
					filter,
					function( index, value ) {
						index = null;
						libFilter.push( value );
					}
				);
			}
		}

		// Create the media frame.
		frame = wp.media(
			{ multiple: false,
				library: { type: libFilter },  // Only allow images.

				// Set the title of the modal.
				title: jQueryel.data( 'choose' ),

				// Customize the submit button.
				button: {

					// Set the text of the button.
					text: jQueryel.data( 'update' )

					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
				}
			}
		);

		// When an image is selected, run a callback.
		frame.on(
			'select',
			function() {

				// Grab the selected attachment.
				var attachment = frame.state().get( 'selection' ).first();
				frame.close();

				data = $( selector ).find( '.data' ).data();

				if ( 'undefined' === typeof welaunch.field_objects.media || undefined === typeof welaunch.field_objects.media ) {
					welaunch.field_objects.media = {};
				}

				if ( undefined === data || 'undefined' === data.mode ) {
					data      = {};
					data.mode = 'image';
				}

				if ( true === isFiltered ) {
					data.mode = 0;
				}

				if ( 0 === data.mode ) {

				} else {
					if ( false !== data.mode ) {
						if ( attachment.attributes.type !== data.mode ) {
							if ( attachment.attributes.subtype !== data.mode ) {
								return;
							}
						}
					}
				}

				selector.find( '.upload' ).val( attachment.attributes.url );
				selector.find( '.upload-id' ).val( attachment.attributes.id );
				selector.find( '.upload-height' ).val( attachment.attributes.height );
				selector.find( '.upload-width' ).val( attachment.attributes.width );

				welaunch_change( $( selector ).find( '.upload-id' ) );

				thumbSrc = attachment.attributes.url;

				if ( 'undefined' !== typeof attachment.attributes.sizes && 'undefined' !== typeof attachment.attributes.sizes.thumbnail ) {
					if ( 'thumbnail' === data.previewSize ) {
						thumbSrc = attachment.attributes.sizes.thumbnail.url;
					}
				} else if ( 'undefined' !== typeof attachment.attributes.sizes ) {
					height = attachment.attributes.height;

					for ( key in attachment.attributes.sizes ) {
						if ( attachment.attributes.sizes.hasOwnProperty( key ) ) {
							object = attachment.attributes.sizes[ key ];

							if ( object.height < height ) {
								height   = object.height;
								thumbSrc = object.url;
							}
						}
					}
				} else {
					thumbSrc = attachment.attributes.icon;
				}

				selector.find( '.upload-thumbnail' ).val( thumbSrc );
				if ( ! selector.find( '.upload' ).hasClass( 'noPreview' ) ) {
					selector.find( '.screenshot' ).empty().hide().append( '<img class="welaunch-option-image" src="' + thumbSrc + '">' ).slideDown( 'fast' );
				}

				selector.find( '.remove-image' ).removeClass( 'hide' ); // Show "Remove" button.
				selector.find( '.welaunch-background-properties' ).slideDown();
			}
		);

		// Finally, open the modal.
		frame.open();
	};

	// Function to remove the image on click. Still requires a save.
	welaunch.field_objects.media.removeFile = function( selector ) {
		var screenshot;

		// This shouldn't have been run...
		if ( ! selector.find( '.remove-image' ).addClass( 'hide' ) ) {
			return;
		}

		selector.find( '.remove-image' ).addClass( 'hide' ); // Hide "Remove" button.
		selector.find( '.upload' ).val( '' );
		selector.find( '.upload-id' ).val( '' );
		selector.find( '.upload-height' ).val( '' );
		selector.find( '.upload-width' ).val( '' );
		selector.find( '.upload-thumbnail' ).val( '' );
		welaunch_change( $( selector ).find( '.upload-id' ) );
		selector.find( '.welaunch-background-properties' ).hide();

		screenshot = selector.find( '.screenshot' );

		// Hide the screenshot.
		screenshot.slideUp();

		selector.find( '.remove-file' ).unbind();

		// We don't display the upload button if .upload-notice is present.
		// This means the user doesn't have the WordPress 3.5 Media Library Support.
		if ( selector.find( '.section-upload .upload-notice' ).length > 0 ) {
			selector.find( '.media_upload_button' ).remove();
		}
	};
} )( jQuery );
