<?php
namespace AIOSEO\Plugin\Addon\LocalBusiness\Blocks;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The Locations block class.
 *
 * @since 1.1.0
 */
class Locations {
	/**
	 * Class constructor.
	 *
	 * @since 1.1.0
	 */
	public function __construct() {
		$this->register();
	}

	/**
	 * Registers the block.
	 *
	 * @since 1.1.0
	 *
	 * @return void
	 */
	public function register() {
		register_block_type(
			'aioseo/locations', [
				'attributes'      => [
					'categoryId' => [
						'type'    => 'number',
						'default' => 0,
					],
				],
				'render_callback' => [ $this, 'render' ],
			]
		);
	}

	/**
	 * Renders the block.
	 *
	 * @since 1.1.0
	 *
	 * @param  array  $blockAttributes The block attributes.
	 * @return string                  The output from the output buffering.
	 */
	public function render( $blockAttributes ) {
		if ( empty( $blockAttributes['categoryId'] ) || ! is_numeric( $blockAttributes['categoryId'] ) ) {
			return;
		}

		ob_start();

		echo esc_html( aioseoLocalBusiness()->locations->outputLocationCategory( absint( $blockAttributes['categoryId'] ), $blockAttributes ) );

		return ob_get_clean();
	}
}