<?php
namespace AIOSEO\Plugin\Addon\Redirects\Main;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Abstract class that Pro and Lite both extend.
 *
 * @since 1.0.0
 */
class Activate {
	/**
	 * Construct method.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		register_activation_hook( AIOSEO_REDIRECTION_MANAGER_FILE, [ $this, 'activate' ] );
	}

	/**
	 * Runs on activate.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function activate() {
		aioseoRedirects()->updates->addRedirectsTables();
	}
}