<?php
/**
 * The template for displaying station archive
 */

get_header();

?>

  <div id="primary" class="content-area">
    <main id="main" class="site-main">
      <?php do_action( 'play_before_archive_header'); ?>
      <header class="archive-header">
          <?php the_archive_title( '<h1 class="archive-title dropdown-toggle" data-toggle="dropdown">', '</h1>' ); ?>
          <div class="dropdown-menu dropdown-term-filter">
            <?php
            $obj = get_queried_object();
            $taxonomy = $obj->taxonomy;
            $arg = array(
                'taxonomy'     => $taxonomy,
                'show_count'   => false,
                'echo'         => 0,
                'hierarchical' => 'false',
                'title_li'     => ''
            );
            $filter_taxonomy = wp_list_categories( apply_filters($taxonomy.'_archive_term_filter', $arg ));
            echo '<ul>'.$filter_taxonomy.'</ul>';
            ?>
          </div>
      </header>
      <?php do_action( 'play_after_archive_header'); ?>
      <div class="archive-content">
      <?php do_action( 'play_before_archive_content'); ?>
      <?php if ( have_posts() ) :?>
          <?php
          $query_arg = array(
            'type' => get_post_type(),
            'pages' => apply_filters('play_archive_pages', 18),
            'pager' => 'more',
            'debug'=> false
          );

          if(is_tax()){
            $query_arg['query'] = array(
              'tax_query' =>
              array(
                array(
                  'taxonomy' => $obj->taxonomy,
                  'field' => 'slug',
                  'terms' => $obj->slug
                )
              )
            );
          }

          $arg = apply_filters('station_archive_'.get_post_type().'_filter', $query_arg);
          
          do_action( 'the_loop_block', $arg);
          ?>
      <?php
      else :
        get_template_part( 'templates/content/content', 'none' );
      endif;
      ?>
      <?php do_action( 'play_after_archive_content'); ?>
      </div>
    </main><!-- #main -->
  </div><!-- #primary -->

<?php
get_footer();
